/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;

public class JavaUtils {
    private static Log log = LogFactory.getLog(JavaUtils.class);

    private JavaUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(String fileName) throws FileNotFoundException, IOException {
        byte[] refBytes = null;
        FileInputStream fisRef = new FileInputStream(fileName);
        UnsyncByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new UnsyncByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = fisRef.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            refBytes = baos.toByteArray();
        }
        finally {
            fisRef.close();
            baos.close();
        }
        return refBytes;
    }

    public static void writeBytesToFilename(String filename, byte[] bytes) {
        block7: {
            FileOutputStream fos = null;
            try {
                if (filename != null && bytes != null) {
                    File f = new File(filename);
                    fos = new FileOutputStream(f);
                    fos.write(bytes);
                    fos.close();
                } else if (log.isDebugEnabled()) {
                    log.debug("writeBytesToFilename got null byte[] pointed");
                }
            }
            catch (IOException ex) {
                if (fos == null) break block7;
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug(ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream baos = null;
        byte[] retBytes = null;
        try {
            int len;
            baos = new UnsyncByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = inputStream.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            retBytes = baos.toByteArray();
        }
        finally {
            baos.close();
        }
        return retBytes;
    }
}

