/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampProcessor
implements Processor {
    private static Log log = LogFactory.getLog(TimestampProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug("Found Timestamp list element");
        }
        WSSConfig config = data.getWssConfig();
        Timestamp timestamp = new Timestamp(elem, config.isWsiBSPCompliant());
        Credential credential = new Credential();
        credential.setTimestamp(timestamp);
        WSSecurityEngineResult result = new WSSecurityEngineResult(32, timestamp);
        result.put("id", timestamp.getID());
        Validator validator = data.getValidator(WSSecurityEngine.TIMESTAMP);
        if (validator != null) {
            validator.validate(credential, data);
            result.put("validated-token", Boolean.TRUE);
        }
        wsDocInfo.addTokenElement(elem);
        wsDocInfo.addResult(result);
        return Collections.singletonList(result);
    }
}

