/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.xfireutil;

import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SignatureStatus;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.security.dsig.IdAttribute;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.security.xfireutil.DSigParseInHandler;
import eu.unicore.security.xfireutil.client.ToBeSignedDecider;
import eu.unicore.util.Log;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Element;
import org.jdom.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSigSecurityInHandler
extends AbstractHandler {
    private static Logger logger = Log.getLogger("unicore.security.dsig", DSigSecurityInHandler.class);
    private static final String WSS_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String WSSUTIL_NS_STRING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private static final Namespace WSS_NS = Namespace.getNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    private static final Namespace XMLDS_NS = Namespace.getNamespace("http://www.w3.org/2000/09/xmldsig#");
    public static final QName WS_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    public static final IdAttribute WS_ID_ATTRIBUTE = new IdAttribute("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    private ToBeSignedDecider partsDecider;

    public DSigSecurityInHandler(ToBeSignedDecider partsDecider) {
        this.setPhase("policy");
        this.after(DSigParseInHandler.class.getName());
        this.after(AuthInHandler.class.getName());
        this.partsDecider = partsDecider;
    }

    @Override
    public void invoke(MessageContext ctx) throws Exception {
        boolean signedOK;
        SecurityTokens securityTokens = (SecurityTokens)ctx.getProperty(SecurityTokens.KEY);
        if (securityTokens == null) {
            logger.error("No security context found. You should add " + AuthInHandler.class.getName() + " handler.");
            return;
        }
        securityTokens.setMessageSignatureStatus(SignatureStatus.UNCHECKED);
        Document doc = (Document)ctx.getProperty(DSigParseInHandler.DOCUMENT_DOM_KEY);
        if (doc == null) {
            logger.debug("No DOM representation of message found, signature won't be checked");
            return;
        }
        long start = System.currentTimeMillis();
        if (securityTokens.getConsignorCertificate() == null) {
            logger.debug("No consignor found in security context so skipping signature verification.");
            return;
        }
        X509Certificate consignorCert = securityTokens.getConsignorCertificate();
        PublicKey consignorsKey = consignorCert.getPublicKey();
        InMessage msg = ctx.getInMessage();
        Element header = msg.getHeader();
        if (header == null) {
            logger.debug("No header found, skipping signature verification.");
            securityTokens.setMessageSignatureStatus(SignatureStatus.UNSIGNED);
            return;
        }
        Element secHeader = header.getChild("Security", WSS_NS);
        if (secHeader == null) {
            logger.debug("No security header element found, skipping signature verification.");
            securityTokens.setMessageSignatureStatus(SignatureStatus.UNSIGNED);
            return;
        }
        if (secHeader.getChild("Signature", XMLDS_NS) == null) {
            logger.debug("No Signature was found in header, skipping signature verification.");
            securityTokens.setMessageSignatureStatus(SignatureStatus.UNSIGNED);
            return;
        }
        long preVerify = System.currentTimeMillis();
        try {
            logger.trace("Starting signature verification");
            signedOK = this.verifySignature(doc, consignorsKey);
        }
        catch (Exception e) {
            logger.warn("Error while checking signature of request: " + e + "\n" + e.getCause());
            securityTokens.setMessageSignatureStatus(SignatureStatus.WRONG);
            return;
        }
        if (signedOK) {
            logger.debug("Signature present and CORRECT");
            securityTokens.setMessageSignatureStatus(SignatureStatus.OK);
        } else {
            logger.warn("Signature present but INCORRECT!!");
            securityTokens.setMessageSignatureStatus(SignatureStatus.WRONG);
        }
        long end = System.currentTimeMillis();
        logger.debug("Total time: " + (end - start) + " where actual verification was: " + (end - preVerify));
    }

    @Override
    public QName[] getUnderstoodHeaders() {
        return new QName[]{WS_SECURITY};
    }

    private boolean verifySignature(Document signedDocument, PublicKey validatingKey) throws DSigException {
        NodeList nl = signedDocument.getElementsByTagNameNS(WSS_NS_STRING, "Security");
        if (nl.getLength() == 0) {
            throw new DSigException("Document not signed");
        }
        if (nl.getLength() > 1) {
            throw new DSigException("Document contains more then one wss:Security element. This is not supported and may indicate an attack on XML digital signature.");
        }
        org.w3c.dom.Element securityElement = (org.w3c.dom.Element)nl.item(0);
        List<org.w3c.dom.Element> signatures = this.getChildElements(securityElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatures.size() == 0) {
            throw new DSigException("Document not signed");
        }
        if (signatures.size() > 1) {
            throw new DSigException("Document's wss:Security element contains more then one dsig:Signature element. This is not supported and may indicate an attack on XML digital signature.");
        }
        DigSignatureUtil dsigEngine = new DigSignatureUtil();
        Node signatureNode = signatures.get(0);
        List<org.w3c.dom.Element> required = this.getRequiredElements(signedDocument);
        return dsigEngine.verifyDetachedSignature(signedDocument, required, WS_ID_ATTRIBUTE, validatingKey, signatureNode);
    }

    private List<org.w3c.dom.Element> getChildElements(org.w3c.dom.Element from, String ns, String localName) {
        ArrayList<org.w3c.dom.Element> ret = new ArrayList<org.w3c.dom.Element>();
        NodeList children = from.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Element childE;
            Node child = children.item(i);
            if (!(child instanceof org.w3c.dom.Element) || !localName.equals((childE = (org.w3c.dom.Element)child).getLocalName()) || !ns.equals(childE.getNamespaceURI())) continue;
            ret.add(childE);
        }
        return ret;
    }

    private List<org.w3c.dom.Element> getRequiredElements(Document signedDocument) {
        Vector<Object> shallBeSigned;
        if (this.partsDecider != null) {
            shallBeSigned = this.partsDecider.getElementsToBeSigned(signedDocument);
        } else {
            shallBeSigned = new Vector();
            shallBeSigned.add(new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", ""));
        }
        ArrayList<org.w3c.dom.Element> ret = new ArrayList<org.w3c.dom.Element>();
        for (WSEncryptionPart wSEncryptionPart : shallBeSigned) {
            logger.trace("Required part: " + wSEncryptionPart.getName());
            NodeList nl = signedDocument.getElementsByTagNameNS(wSEncryptionPart.getNamespace(), wSEncryptionPart.getName());
            if (nl.getLength() == 0) continue;
            for (int i = 0; i < nl.getLength(); ++i) {
                ret.add((org.w3c.dom.Element)nl.item(i));
            }
        }
        return ret;
    }
}

