/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.dsig;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class Utils {
    private static final Logger log = Logger.getLogger("unicore.security." + Utils.class.getSimpleName());

    private static X509Certificate deserializeCertificate(byte[] encodedCert) {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert);
        try {
            return CertificateUtils.loadCertificate(bais, CertificateUtils.Encoding.DER);
        }
        catch (IOException e) {
            log.warn("Error while deserializing certificate from key info: " + e);
            return null;
        }
    }

    public static X509Certificate[] deserializeCertificateChain(byte[][] encodedCerts) {
        X509Certificate[] retval = new X509Certificate[encodedCerts.length];
        for (int i = 0; i < encodedCerts.length; ++i) {
            retval[i] = Utils.deserializeCertificate(encodedCerts[i]);
        }
        return retval;
    }
}

