/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.security.dsig.DSigException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;

public class AssertionResponse
extends AbstractStatusResponse {
    private ResponseType respXml;
    private ResponseDocument xbdoc;

    public AssertionResponse(ResponseDocument src) throws SAMLParseException {
        super(src.getResponse());
        this.xbdoc = src;
        this.respXml = src.getResponse();
    }

    public AssertionResponse(NameID issuer, String inResponseTo) {
        this.xbdoc = ResponseDocument.Factory.newInstance();
        this.respXml = this.xbdoc.addNewResponse();
        this.init(this.respXml, issuer, inResponseTo);
        this.respXml.setStatus(this.getOKStatus());
    }

    public AssertionResponse(NameID issuer, String inResponseTo, SAMLProtocolException error) {
        this.xbdoc = ResponseDocument.Factory.newInstance();
        this.respXml = this.xbdoc.addNewResponse();
        this.init(this.respXml, issuer, inResponseTo);
        this.respXml.setStatus(this.getErrorStatus(error));
    }

    @Override
    public ResponseDocument getDoc() {
        return this.xbdoc;
    }

    public void addAssertion(Assertion ass) {
        AssertionType at = this.respXml.addNewAssertion();
        at.set(ass.getXML().getAssertion());
    }

    public Assertion[] getAssertions() throws SAMLParseException, XmlException, IOException {
        Element node = (Element)this.respXml.getDomNode();
        NodeList allChildren = node.getChildNodes();
        NodeList asNodes = node.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (asNodes == null || asNodes.getLength() == 0) {
            return new Assertion[0];
        }
        ArrayList<Assertion> ret = new ArrayList<Assertion>(asNodes.getLength());
        for (int i = 0; i < asNodes.getLength(); ++i) {
            Node asNode = asNodes.item(i);
            for (int j = 0; j < allChildren.getLength(); ++j) {
                if (!allChildren.item(j).equals(asNode)) continue;
                AssertionDocument wrapper = AssertionDocument.Factory.parse(asNode);
                ret.add(new Assertion(wrapper));
            }
        }
        return ret.toArray(new Assertion[ret.size()]);
    }

    @Override
    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = ResponseDocument.Factory.parse(doc);
            this.respXml = this.xbdoc.getResponse();
            this.xmlResp = this.xbdoc.getResponse();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

