/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2;

import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;
import xmlbeans.org.w3.x2000.x09.xmldsig.SignatureType;
import xmlbeans.org.w3.x2000.x09.xmldsig.X509DataType;

public class SAMLUtils {
    public static String genID(String prefix) {
        Random r = new Random(new Date().getTime());
        StringBuffer id = new StringBuffer(prefix);
        for (int i = 0; i < 3; ++i) {
            id.append(Long.toHexString(r.nextLong()));
        }
        return id.toString();
    }

    public static X509Certificate[] getIssuerFromSignature(SignatureType signature) {
        if (signature == null) {
            return null;
        }
        KeyInfoType ki = signature.getKeyInfo();
        if (ki == null) {
            return null;
        }
        X509DataType[] x509Data = ki.getX509DataArray();
        if (x509Data == null) {
            return null;
        }
        for (int i = 0; i < x509Data.length; ++i) {
            if (x509Data[i].getX509CertificateArray().length <= 0) continue;
            return Utils.deserializeCertificateChain(x509Data[i].getX509CertificateArray());
        }
        return null;
    }

    public static Document getDOM(XmlObject xmlO) throws DSigException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document docToSign = builder.parse(xmlO.newInputStream());
            return docToSign;
        }
        catch (ParserConfigurationException e) {
            throw new DSigException("Can't configure DOM parser", e);
        }
        catch (SAXException e) {
            throw new DSigException("DOM parse exception", e);
        }
        catch (IOException e) {
            throw new DSigException("IO Exception while parsing DOM ??", e);
        }
    }
}

