/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.grid.BaseStorage;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.unicore6.Unicore6Grid;
import eu.unicore.hila.grid.unicore6.Unicore6Job;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.hila.grid.unicore6.Unicore6Site;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

@ResourceType(locationStructure={"unicore6:/sites/{site}/storages/{storage}/?", "unicore6:/{user}@sites/{site}/storages/{storage}/?", "unicore6:/sites/{site}/tasks/{task}/wd/?", "unicore6:/{user}@sites/{site}/tasks/{task}/wd/?", "unicore6:/storages/{storage}/?", "unicore6:/{user}@storages/{storage}/?"})
public class Unicore6Storage
extends BaseStorage
implements Storage {
    private static final Logger log = Logger.getLogger(Unicore6Storage.class);
    private static final Map<Location, Unicore6Storage> storages = new HashMap<Location, Unicore6Storage>();
    private StorageClient storageClient = null;
    private EndpointReferenceType storageEPR;
    private Unicore6SecurityProperties sec;

    private Unicore6Storage(Location _location, Object ... _extraInformation) throws HiLAException {
        super(_location);
        for (Object object : _extraInformation) {
            if (object instanceof EndpointReferenceType) {
                this.storageEPR = (EndpointReferenceType)object;
                continue;
            }
            if (object instanceof Unicore6SecurityProperties) {
                this.sec = (Unicore6SecurityProperties)object;
                continue;
            }
            if (!(object instanceof StorageClient)) continue;
            this.storageClient = (StorageClient)object;
        }
        if (this.storageClient != null) {
            return;
        }
        if (this.storageEPR != null && this.sec != null) {
            try {
                this.storageClient = new StorageClient(this.storageEPR, this.sec);
            }
            catch (Exception e) {
                throw new HiLAException("Unable to instantiate client for storage: " + this.location, (Throwable)e);
            }
        } else {
            throw new HiLAException("Insufficient information to create storage client.");
        }
    }

    public static synchronized Unicore6Storage locate(Location _location, Object ... _extraInformation) throws HiLAException {
        if (storages.containsKey(_location)) {
            return storages.get(_location);
        }
        boolean containsEPR = false;
        boolean containsSecProp = false;
        boolean containsStorageClient = false;
        if (_extraInformation != null) {
            for (Object object : _extraInformation) {
                if (object instanceof EndpointReferenceType) {
                    containsEPR = true;
                }
                if (object instanceof Unicore6SecurityProperties) {
                    containsSecProp = true;
                }
                if (!(object instanceof StorageClient)) continue;
                containsStorageClient = true;
            }
        }
        if (!(containsEPR && containsSecProp || containsStorageClient)) {
            try {
                Location taskLocation = Unicore6Storage.findParentLocationOfType(Unicore6Job.class, (Location)_location, Unicore6Grid.class);
                Unicore6Job task = (Unicore6Job)taskLocation.locate(new Object[0]);
                if (task != null) {
                    StorageClient storageClient = task.jobClient.getUspaceClient();
                    Unicore6Storage storage = new Unicore6Storage(_location, storageClient);
                    storages.put(_location, storage);
                    return storage;
                }
            }
            catch (HiLAException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            Location siteLocation = Unicore6Storage.findParentLocationOfType(Unicore6Site.class, (Location)_location, Unicore6Grid.class);
            return (Unicore6Storage)((Site)siteLocation.locate(new Object[0])).getStorage(_location.getName());
        }
        Unicore6Storage storage = new Unicore6Storage(_location, _extraInformation);
        storages.put(_location, storage);
        return storage;
    }

    protected StorageClient getStorageClient() {
        return this.storageClient;
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        children.addAll(super.getChildren());
        try {
            children.add(this.location.getChildLocation("exports").locate(new Object[0]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        try {
            children.add(this.location.getChildLocation("imports").locate(new Object[0]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        try {
            children.add(this.location.getChildLocation("transfers").locate(new Object[0]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return children;
    }
}

