/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.ReservationClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationPatternException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Reservable;
import eu.unicore.hila.grid.Reservation;
import eu.unicore.hila.grid.Site;
import java.util.Collections;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

@ResourceType(locationStructure={"unicore6:/sites/{siteName}/reservations/{reservation}/?", "unicore6:/{user}@sites/{siteName}/reservations/{reservation}/?"})
public class Unicore6Reservation
extends BaseResource
implements Reservation {
    private ReservationClient resClient;
    private Metadata metadata = new Metadata();
    private static Cache reservationsCache;

    private Unicore6Reservation(Location _location, ReservationClient _resClient) {
        super(_location);
        this.resClient = _resClient;
    }

    public static synchronized Resource locate(Location _location, Object ... _extraInformation) throws HiLAException {
        Element cacheElem;
        if (reservationsCache.isKeyInCache(_location) && (cacheElem = reservationsCache.get(_location)) != null) {
            return (Resource)cacheElem.getObjectValue();
        }
        ReservationClient reservationClient = null;
        for (Object object : _extraInformation) {
            if (!(object instanceof ReservationClient)) continue;
            reservationClient = (ReservationClient)object;
        }
        if (reservationClient == null) {
            try {
                Reservation reservation = ((Reservable)Unicore6Reservation.findParentLocationOfType(Site.class, (Location)_location, Grid.class).locate(new Object[0])).getReservation(_location.getName());
                if (reservation != null) {
                    return reservation;
                }
                throw new HiLAFactoryException("Reservation " + _location + " does not exist.");
            }
            catch (HiLALocationPatternException e) {
                throw new HiLAFactoryException(Unicore6Reservation.class.getName() + "#locate() created wrong location.");
            }
        }
        Unicore6Reservation u6res = new Unicore6Reservation(_location, reservationClient);
        reservationsCache.put(new Element(_location, (Object)u6res));
        return u6res;
    }

    public List<Resource> getChildren() throws HiLAException {
        return Collections.emptyList();
    }

    public void cancel() throws HiLAException {
        try {
            this.resClient.destroy();
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to cancel reservation.", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException("Reservation does not exist.", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException("Reservation does not exist.", (Throwable)e);
        }
        catch (ResourceNotDestroyedFault e) {
            throw new HiLAException("Unable to cancel reservation.", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("Client exception.", (Throwable)e);
        }
    }

    public Metadata getMetadata() throws HiLAException {
        this.updateMetadata();
        return this.metadata;
    }

    private void updateMetadata() throws HiLAException {
        try {
            this.metadata.setData("resourceProperties", (Object)this.resClient.getResourcePropertyDocument());
        }
        catch (BaseFault e) {
            throw new HiLAException("Unable to retrieve resourceProperties.", (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new HiLAException("Unknown resource.", (Throwable)e);
        }
        catch (ResourceUnavailableFault e) {
            throw new HiLAException("Unavailable resource.", (Throwable)e);
        }
        catch (ClientException e) {
            throw new HiLAException("Client exception.", (Throwable)e);
        }
    }

    public String getId() throws HiLAException {
        try {
            return this.resClient.getReservationReference();
        }
        catch (Exception e) {
            throw new HiLAException("Cannot determine reservation id.", (Throwable)e);
        }
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        manager.addCache(new Cache(Unicore6Reservation.class.getName(), 100, false, false, 300L, 60L));
        reservationsCache = manager.getCache(Unicore6Reservation.class.getName());
    }
}

