/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseThirdPartyTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.ThirdPartyTransfer;
import eu.unicore.hila.grid.unicore6.TasksHelper;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import eu.unicore.hila.grid.unicore6.Unicore6TransfersCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;

public class Unicore6RecursiveTransferTask
extends BaseThirdPartyTransfer
implements ThirdPartyTransfer,
Callable<TaskStatus>,
Progressable {
    private final Unicore6File source;
    private final Unicore6File destination;
    private final List<ThirdPartyTransfer> transfers;
    private boolean abort = false;
    private boolean allCreated = false;

    public Unicore6RecursiveTransferTask(Unicore6File _source, Unicore6File _destination) throws HiLAException {
        super(_source.getStorage().getLocation().getChildLocation("transfers").getChildLocation(UUID.randomUUID().toString()));
        this.source = _source;
        this.destination = _destination;
        this.transfers = new ArrayList<ThirdPartyTransfer>();
        this.setCurrentState(TaskStatus.NEW);
        HiLA.getExecutor().submit(this);
        Unicore6TransfersCollection tc = (Unicore6TransfersCollection)this.getParent();
        if (tc != null) {
            tc.addTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws HiLAException {
        this.abort = true;
        Unicore6RecursiveTransferTask unicore6RecursiveTransferTask = this;
        synchronized (unicore6RecursiveTransferTask) {
            if (!this.allCreated) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        for (ThirdPartyTransfer transfer : this.transfers) {
            transfer.abort();
        }
    }

    public String getId() throws HiLAException {
        return this.location.getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        return Collections.singletonList(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        if (!this.destination.exists()) {
            this.destination.mkdir();
        }
        Unicore6RecursiveTransferTask unicore6RecursiveTransferTask = this;
        synchronized (unicore6RecursiveTransferTask) {
            List<File> files = this.source.ls();
            for (File file : files) {
                this.transfers.add(file.transfer((File)this.destination, false, true));
                if (!this.abort) continue;
                break;
            }
            this.allCreated = true;
            this.notify();
        }
        while (TasksHelper.hasPendingTasks(this.transfers)) {
            Thread.sleep(2000L);
        }
        if (!TasksHelper.allTasksSuccessful(this.transfers)) {
            HiLAException e = new HiLAException("Not all pending transfers were successful.");
            this.setCurrentState(TaskStatus.FAILED, e);
            throw e;
        }
        this.setCurrentState(TaskStatus.SUCCESSFUL);
        return this.status();
    }
}

