/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Submittable;
import eu.unicore.hila.grid.job.JobDescription;
import eu.unicore.hila.grid.unicore6.Unicore6OrchestratorJob;
import eu.unicore.hila.grid.unicore6.Unicore6SecurityProperties;
import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.MappingFactorySpi;
import eu.unicore.hila.job.spi.ModelToNative;
import eu.unicore.hila.job.spi.NativeToModel;
import eu.unicore.hila.job.spi.NoSuchMappingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.chemomentum.common.ws.IServiceOrchestrator;
import org.chemomentum.workassignment.xmlbeans.SubmitWorkAssignmentRequestDocument;
import org.chemomentum.workassignment.xmlbeans.WorkAssignmentDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

@ResourceType(locationStructure={"unicore6:/orchestrators/{orchestrator}/?", "unicore6:/{user}@orchestrators/{orchestrator}/?"})
public class Unicore6Orchestrator
extends BaseResource
implements Submittable {
    private static Map<Location, Unicore6Orchestrator> orchestrators = new HashMap<Location, Unicore6Orchestrator>();
    private IServiceOrchestrator orchestrator;
    private Unicore6SecurityProperties secprop;
    private List<Job> tasks = new ArrayList<Job>();

    private Unicore6Orchestrator(Location _location, IServiceOrchestrator _orchestrator, Unicore6SecurityProperties _secprop) {
        super(_location);
        this.orchestrator = _orchestrator;
        this.secprop = _secprop;
    }

    public static synchronized Unicore6Orchestrator locate(Location _location, Object ... _extraInformation) throws HiLAException {
        if (orchestrators.containsKey(_location)) {
            return orchestrators.get(_location);
        }
        IServiceOrchestrator orchestrator = null;
        Unicore6SecurityProperties secprop = null;
        for (Object object : _extraInformation) {
            if (object instanceof IServiceOrchestrator) {
                orchestrator = (IServiceOrchestrator)object;
                continue;
            }
            if (!(object instanceof Unicore6SecurityProperties)) continue;
            secprop = (Unicore6SecurityProperties)object;
        }
        if (orchestrator != null && secprop != null) {
            Unicore6Orchestrator u6orchestrator = new Unicore6Orchestrator(_location, orchestrator, secprop);
            orchestrators.put(_location, u6orchestrator);
            return u6orchestrator;
        }
        _location.getParentLocation().locate(new Object[0]).getChildren();
        return (Unicore6Orchestrator)_location.locate(new Object[0]);
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(this.getTasks());
        return resources;
    }

    public Job submit(JobModel _jd) throws HiLAException {
        MappingFactorySpi mapping;
        try {
            mapping = MappingFactory.getMapping((String)"jsdl");
        }
        catch (NoSuchMappingException e) {
            throw new HiLAException("Unable to map job model to JSDL.", (Throwable)e);
        }
        ModelToNative m2n = mapping.createModelToNativeMapping(_jd);
        JobDefinitionDocument actualJobDescription = (JobDefinitionDocument)m2n.getNative();
        WorkAssignmentDocument theWA = null;
        if (actualJobDescription instanceof JobDefinitionDocument) {
            JobDefinitionDocument jsdl = actualJobDescription;
            WorkAssignmentDocument wad = WorkAssignmentDocument.Factory.newInstance();
            wad.addNewWorkAssignment().addNewWork().setJobDefinition(jsdl.getJobDefinition());
            wad.getWorkAssignment().setId(UUID.randomUUID().toString());
            theWA = wad;
        } else if (actualJobDescription instanceof WorkAssignmentDocument) {
            theWA = (WorkAssignmentDocument)((Object)actualJobDescription);
        } else {
            throw new HiLAException("I don't understand this job description.");
        }
        SubmitWorkAssignmentRequestDocument swareqd = SubmitWorkAssignmentRequestDocument.Factory.newInstance();
        swareqd.addNewSubmitWorkAssignmentRequest().setWorkAssignment(theWA.getWorkAssignment());
        this.orchestrator.submitWorkAssignment(swareqd);
        Unicore6OrchestratorJob orchJob = new Unicore6OrchestratorJob(this.location.getChildLocation(theWA.getWorkAssignment().getId()), this.orchestrator, this.secprop);
        this.tasks.add(orchJob);
        return orchJob;
    }

    public List<Job> getTasks() throws HiLAException {
        return this.tasks;
    }

    public Job getTask(String _taskId) throws HiLAException {
        return null;
    }

    public Job submit(JobDescription _jd) throws HiLAException {
        if (_jd.getActualJobDescription() instanceof JobDefinitionDocument) {
            JobDefinitionDocument jsdl = (JobDefinitionDocument)_jd.getActualJobDescription();
            try {
                MappingFactorySpi mapping = MappingFactory.getMapping((String)"jsdl");
                NativeToModel n2m = mapping.createNativeToModelMapping((Object)jsdl);
                return this.submit(n2m.getModel());
            }
            catch (NoSuchMappingException e) {
                throw new HiLAException("Cannot map jsdl to abstract model.", (Throwable)e);
            }
        }
        throw new HiLAFactoryException("Unable to map input JobDescription to the job model.");
    }
}

