/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.hila.HiLA;
import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.grid.unicore6.Unicore6File;
import eu.unicore.hila.grid.unicore6.util.FileTransfers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class Unicore6ExportToStreamTask
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private final StorageClient storageClient;
    private final String decodedPath;
    private final OutputStream os;
    private final Future<TaskStatus> transferFuture;

    public Unicore6ExportToStreamTask(Location storageLocation, StorageClient _storageClient, String _decodedPath, Unicore6File _unicore6File, OutputStream _os) throws HiLAException {
        super(storageLocation.getChildLocation("exports").getChildLocation(UUID.randomUUID().toString()));
        this.storageClient = _storageClient;
        this.decodedPath = _decodedPath;
        this.os = _os;
        this.setCurrentState(TaskStatus.NEW);
        this.transferFuture = HiLA.getExecutor().submit(this);
    }

    public void abort() throws HiLAException {
        this.transferFuture.cancel(true);
        this.setCurrentState(TaskStatus.ABORTED);
    }

    public String getId() throws HiLAException {
        return this.getLocation().getName();
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> children = new ArrayList<Resource>();
        return children;
    }

    @Override
    public TaskStatus call() throws HiLAException {
        this.setCurrentState(TaskStatus.RUNNING);
        try {
            HashMap<String, String> extraParameters = new HashMap<String, String>();
            FileTransfers.getDefaultUftpParameters(extraParameters);
            FileTransferClient ftc = this.storageClient.getExport(this.decodedPath, extraParameters, FileTransfers.getFTPrefs());
            ftc.readAllData(this.os);
            this.os.flush();
            this.setCurrentState(TaskStatus.SUCCESSFUL);
        }
        catch (IOException e) {
            HiLAException e2 = new HiLAException("Failed to export to stream.", (Throwable)e);
            this.setCurrentState(TaskStatus.FAILED, e2);
            throw e2;
        }
        catch (Exception e) {
            HiLAException e2 = new HiLAException("Failed to export to stream.", (Throwable)e);
            this.setCurrentState(TaskStatus.FAILED, e2);
            throw e2;
        }
        return this.status();
    }
}

