/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Grid;
import eu.unicore.hila.grid.Site;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ResourceType(locationStructure={"unicore6:/sites/{site}/tasks/?", "unicore6:/{user}@sites/{site}/tasks/?"})
public class TasksCollection
extends BaseResource
implements Resource {
    public static final String TASKS = "tasks";
    private static final Map<Location, TasksCollection> tasksCollections = new HashMap<Location, TasksCollection>();

    private TasksCollection(Location location) {
        super(location);
    }

    public static synchronized Resource locate(Location _location) {
        if (tasksCollections.containsKey(_location)) {
            return tasksCollections.get(_location);
        }
        TasksCollection tasksCollection = new TasksCollection(_location);
        tasksCollections.put(_location, tasksCollection);
        return tasksCollection;
    }

    public List<Resource> getChildren() throws HiLAException {
        ArrayList<Resource> tasks = new ArrayList<Resource>();
        Location siteLoc = TasksCollection.findParentLocationOfType(Site.class, (Location)this.location, Grid.class);
        if (siteLoc != null) {
            Site site = (Site)siteLoc.locate(new Object[0]);
            tasks.addAll(site.getTasks());
        }
        return tasks;
    }
}

