/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.grid.unicore6;

import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAAccessDeniedException;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.unicore6.Unicore6Site;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.codehaus.xfire.fault.XFireFault;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

class GetSitesFromTSF
implements Callable<List<Site>> {
    private static final Logger log = Logger.getLogger(GetSitesFromTSF.class);
    private EndpointReferenceType tsfEpr = null;
    private IClientConfiguration security;
    private Location location;
    private boolean separateTSSs = false;

    public GetSitesFromTSF(EndpointReferenceType _tsfURL, IClientConfiguration secProps, Location _location, boolean _separateTSSs) {
        if (log.isDebugEnabled()) {
            log.debug("Initializing " + this + " with _tsfURL: " + _tsfURL + ", _location: " + _location + ", _separateTSSs: " + _separateTSSs);
        }
        this.tsfEpr = _tsfURL;
        this.security = secProps;
        this.location = _location;
        this.separateTSSs = _separateTSSs;
    }

    @Override
    public List<Site> call() throws Exception {
        ArrayList<Site> sites = new ArrayList<Site>();
        TSFClient tsfClient = new TSFClient(this.tsfEpr.getAddress().getStringValue(), this.tsfEpr, this.security);
        try {
            TSSClient tssClient;
            List<EndpointReferenceType> existingTssEprs = tsfClient.getAccessibleTargetSystems();
            if (log.isDebugEnabled()) {
                log.debug("Found " + existingTssEprs.size() + " Target Systems entries in TSF.");
                if (log.isTraceEnabled()) {
                    for (EndpointReferenceType endpointReference : existingTssEprs) {
                        log.trace(endpointReference);
                    }
                }
            }
            ArrayList<EndpointReferenceType> newTssEprs = new ArrayList<EndpointReferenceType>();
            if ((existingTssEprs == null || existingTssEprs.size() == 0) && (tssClient = tsfClient.createTSS()) != null) {
                newTssEprs.add(tssClient.getEPR());
            }
            if (existingTssEprs != null) {
                newTssEprs.addAll(existingTssEprs);
            }
            if (this.separateTSSs) {
                if (log.isDebugEnabled()) {
                    log.debug("Generating separate Sites for TSSs.");
                }
                for (EndpointReferenceType tssEpr : newTssEprs) {
                    TSSClient tssClient2 = new TSSClient(tssEpr.getAddress().getStringValue(), tssEpr, this.security);
                    try {
                        String siteName = tssClient2.getTargetSystemName();
                        Calendar upSince = tssClient2.getUpSince();
                        String dateString = GetSitesFromTSF.constructDateString(upSince);
                        Location siteLocation = this.location.getChildLocation(siteName.concat("_").concat(dateString));
                        if (log.isTraceEnabled()) {
                            log.trace("Generating site " + siteLocation);
                        }
                        sites.add((Unicore6Site)siteLocation.locate(new Object[]{Collections.singletonList(tssClient2), tsfClient}));
                    }
                    catch (Exception e) {
                        log.error("Something went wrong.", e);
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Generating single site for multiple TSSs.");
                }
                ArrayList<TSSClient> tssClients = new ArrayList<TSSClient>();
                for (EndpointReferenceType tssEpr : newTssEprs) {
                    TSSClient tssClient3 = new TSSClient(tssEpr.getAddress().getStringValue(), tssEpr, this.security);
                    if (log.isTraceEnabled()) {
                        log.trace("Adding " + tssClient3 + " to list.");
                    }
                    tssClients.add(tssClient3);
                }
                sites.add((Unicore6Site)this.location.getChildLocation(((TSSClient)tssClients.get(0)).getTargetSystemName()).locate(new Object[]{tssClients, tsfClient}));
            }
        }
        catch (XFireFault e) {
            if (e.getMessage().contains("Access denied")) {
                throw new HiLAAccessDeniedException(e.getMessage());
            }
            throw new HiLAException(e.getMessage());
        }
        catch (Exception e) {
            throw new HiLAException(e.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning list of " + sites.size() + " sites.");
        }
        return sites;
    }

    public static String constructDateString(Calendar upSince) {
        String dateString = Integer.toString(upSince.get(1)) + (upSince.get(2) + 1 < 10 ? "0" : "") + Integer.toString(upSince.get(2) + 1) + (upSince.get(5) < 10 ? "0" : "") + Integer.toString(upSince.get(5)) + (upSince.get(11) < 10 ? "0" : "") + Integer.toString(upSince.get(11)) + (upSince.get(12) < 10 ? "0" : "") + Integer.toString(upSince.get(12));
        return dateString;
    }
}

