/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.helpers.pkipath.PlainCRLValidator;
import eu.emi.security.authn.x509.helpers.trust.DirectoryTrustAnchorStore;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.ValidatorParamsExt;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.List;

public class DirectoryCertChainValidator
extends PlainCRLValidator {
    private DirectoryTrustAnchorStore trustStore;

    public DirectoryCertChainValidator(List<String> trustedLocations, CertificateUtils.Encoding encoding, long truststoreUpdateInterval, int connectionTimeoutCA, String diskCache, ValidatorParamsExt params) throws KeyStoreException, IOException {
        super(params.getRevocationSettings(), params.getInitialListeners());
        this.trustStore = new DirectoryTrustAnchorStore(trustedLocations, diskCache, connectionTimeoutCA, timer, truststoreUpdateInterval, encoding, this.observers);
        this.init(this.trustStore, this.crlStoreImpl, params.isAllowProxy(), params.getRevocationSettings());
    }

    public DirectoryCertChainValidator(List<String> trustedLocations, CertificateUtils.Encoding encoding, long truststoreUpdateInterval, int connectionTimeoutCA, String diskCache) throws KeyStoreException, IOException {
        this(trustedLocations, encoding, truststoreUpdateInterval, connectionTimeoutCA, diskCache, new ValidatorParamsExt());
    }

    public DirectoryCertChainValidator(String trustedLocation, String crlLocation, String diskCache) throws KeyStoreException, IOException {
        this(Collections.singletonList(trustedLocation), CertificateUtils.Encoding.PEM, 3600000L, 15000, diskCache, new ValidatorParamsExt(new RevocationParametersExt(CrlCheckingMode.IF_VALID, new CRLParameters(Collections.singletonList(crlLocation), 3600000L, 15000, diskCache), new OCSPParametes()), ValidatorParams.DEFAULT_PROXY_SUPPORT));
    }

    public long getTruststoreUpdateInterval() {
        return this.trustStore.getUpdateInterval();
    }

    public void setTruststoreUpdateInterval(long updateInterval) {
        this.trustStore.setUpdateInterval(updateInterval);
    }

    public List<String> getTruststorePaths() {
        return this.trustStore.getLocations();
    }

    public void setTruststorePaths(List<String> trustedLocations) {
        long savedUpdateInterval = this.trustStore.getUpdateInterval();
        this.trustStore.dispose();
        this.trustStore = new DirectoryTrustAnchorStore(trustedLocations, this.trustStore.getCacheDir(), this.trustStore.getConnTimeout(), timer, savedUpdateInterval, this.trustStore.getEncoding(), this.observers);
        this.init(this.trustStore, null, this.getProxySupport(), this.getRevocationCheckingMode());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.trustStore.dispose();
    }
}

