/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.util;

import de.fzj.unicore.wsrflite.xmlbeans.wsn.Topic;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNConstants;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNTopicExpression;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.WSNTopicExpressionType;
import java.io.IOException;
import javax.naming.NameAlreadyBoundException;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.oasisOpen.docs.wsn.b2.TopicExpressionDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionType;
import org.oasisOpen.docs.wsn.t1.ConcreteTopicExpression;

public class ConcreteWSNTopicExpression
implements WSNConstants,
WSNTopicExpression,
WSNTopicExpressionType {
    private Topic topic;

    public ConcreteWSNTopicExpression() {
    }

    public ConcreteWSNTopicExpression(Topic topic) {
        this.topic = topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopicExpressionDocument toXml() {
        TopicExpressionDocument td = TopicExpressionDocument.Factory.newInstance();
        TopicExpressionType t = td.addNewTopicExpression();
        ConcreteTopicExpression ste = ConcreteTopicExpression.Factory.newInstance();
        StringBuilder builder = new StringBuilder();
        XmlCursor cursor = ste.newCursor();
        try {
            cursor.toNextToken();
            Topic topic = this.topic;
            String lastNamespaceURI = "";
            while (topic != null) {
                String ns;
                if (builder.length() != 0) {
                    builder.append('/');
                }
                if ((ns = topic.getNamespace()) != null) {
                    if (!lastNamespaceURI.equals(ns)) {
                        String prefix = cursor.prefixForNamespace(ns);
                        cursor.insertNamespace(prefix, ns);
                        builder.append(prefix + ":");
                    }
                    lastNamespaceURI = ns;
                }
                builder.append(topic.getName());
                Topic[] children = topic.getChildren();
                if (children.length > 0) {
                    topic = children[0];
                    continue;
                }
                topic = null;
            }
        }
        finally {
            cursor.dispose();
        }
        ste.setStringValue(builder.toString());
        t.set(ste);
        t.setDialect(this.getDialect());
        return td;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WSNTopicExpression fromXml(TopicExpressionType type) throws XmlException, IOException {
        ConcreteTopicExpression concrete = ConcreteTopicExpression.Factory.parse(type.newInputStream());
        String expression = concrete.getStringValue();
        XmlCursor cursor = concrete.newCursor();
        Topic root = null;
        Topic current = null;
        Topic next = null;
        try {
            String lastNamespaceURI = null;
            String lastPrefix = null;
            for (String element : expression.split("/")) {
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException(String.format("\"%s\" is not a valid Topic expression.", expression));
                }
                int index = element.indexOf(58);
                if (index < 0) {
                    if (lastNamespaceURI == null) {
                        throw new IllegalArgumentException(String.format("Can't tell what namespace to start with.", new Object[0]));
                    }
                } else if (index > 0) {
                    lastPrefix = element.substring(0, index);
                    element = element.substring(index + 1);
                    lastNamespaceURI = cursor.namespaceForPrefix(lastPrefix);
                    if (lastNamespaceURI == null) {
                        throw new IllegalArgumentException(String.format("Can't find a namespace for prefix %s.", lastPrefix));
                    }
                } else {
                    throw new IllegalArgumentException(String.format("%s is not a valid topic node.", element));
                }
                next = new Topic(lastNamespaceURI, element);
                if (root == null) {
                    root = next;
                }
                if (current != null) {
                    current.addChild(next);
                }
                current = next;
            }
        }
        catch (NameAlreadyBoundException e) {
        }
        finally {
            cursor.dispose();
        }
        return new ConcreteWSNTopicExpression(root);
    }

    @Override
    public boolean matches(Topic t) {
        Topic a = this.topic;
        for (Topic b = t; a != null && b != null; b = b.getChild(a.getName())) {
            if (!a.getQName().equals(b.getQName())) {
                return false;
            }
            if (a.hasChildren()) {
                if (!b.hasChildren()) {
                    return false;
                }
                a = a.getChildren()[0];
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDialect() {
        return "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcreteWSNTopicExpression)) {
            return false;
        }
        ConcreteWSNTopicExpression other = (ConcreteWSNTopicExpression)obj;
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }
}

