/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.client;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationConsumer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.SimpleTopic;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observer;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsn.b2.NotificationMessageHolderType;
import org.oasisOpen.docs.wsn.b2.NotifyDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionType;

public class Consumer
implements NotificationConsumer {
    protected static final Logger logger = Log.getLogger("unicore.wsrflite", Consumer.class);
    private static final HashMap<QName, ArrayList<Observer>> observers = new HashMap();

    @Override
    public void Notify(NotifyDocument req) throws BaseFault {
        NotificationMessageHolderType[] messages;
        if (logger.isDebugEnabled()) {
            logger.debug("Received notification: " + req);
        } else {
            logger.info("Received notification.");
        }
        for (NotificationMessageHolderType message : messages = req.getNotify().getNotificationMessageArray()) {
            this.handleMessage(message);
        }
    }

    protected void handleMessage(NotificationMessageHolderType message) {
        QName event = this.extractEvent(message.getTopic());
        logger.info("Event: " + event);
        this.doNotifyObservers(event, message);
    }

    protected QName extractEvent(TopicExpressionType t) {
        return SimpleTopic.extractQName(t);
    }

    protected void doNotifyObservers(QName event, NotificationMessageHolderType msg) {
        ArrayList<Observer> obs = observers.get(event);
        if (obs == null) {
            return;
        }
        logger.info("Notifying " + obs.size() + " observers");
        for (Observer o : obs) {
            try {
                o.update(null, msg);
            }
            catch (Exception e) {
                logger.warn("Could not notify " + o.toString(), e);
            }
        }
    }

    public static void addObserver(Observer observer, QName event) {
        ArrayList<Observer> o = observers.get(event);
        if (o == null) {
            o = new ArrayList();
        }
        o.add(observer);
        observers.put(event, o);
    }
}

