/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import eu.unicore.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.handler.AbstractHandler;

public class MTOMInHandler
extends AbstractHandler {
    private static final Logger logger = Log.getLogger("unicore.wsrflite", MTOMInHandler.class);
    private static final ThreadLocal<byte[]> attachments = new ThreadLocal();

    @Override
    public void invoke(MessageContext context) throws Exception {
        attachments.remove();
        if (context.getInMessage() == null || context.getInMessage().getAttachments() == null) {
            return;
        }
        Attachments atts = context.getInMessage().getAttachments();
        if (atts == null) {
            return;
        }
        Iterator iter = atts.getParts();
        while (iter.hasNext()) {
            Attachment a = (Attachment)iter.next();
            logger.debug("Reading attachment " + a.getId());
            InputStream is = a.getDataHandler().getInputStream();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int l = 0;
            while ((l = is.read(buf)) != -1) {
                bos.write(buf, 0, l);
            }
            attachments.set(bos.toByteArray());
            logger.debug("Read " + bos.size() + " bytes attachment.");
            try {
                is.close();
            }
            catch (Exception ex) {}
        }
    }

    public static byte[] getAttachment() {
        return attachments.get();
    }
}

