/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.TSSClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.unigrids.services.atomic.types.SecurityType;
import org.unigrids.x2006.x04.services.tsf.CreateTSRDocument;
import org.unigrids.x2006.x04.services.tsf.CreateTSRResponseDocument;
import org.unigrids.x2006.x04.services.tsf.TargetSystemFactoryPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TSFClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger("unicore.client", TSFClient.class);
    private final TargetSystemFactory tsf = this.makeProxy(TargetSystemFactory.class);

    public TSFClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
        this.setRetryDefaults();
    }

    public TSFClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public TSSClient createTSS(CreateTSRDocument in) throws Exception {
        logger.info("Calling target system factory service at: " + this.getEPR().getAddress().getStringValue());
        CreateTSRResponseDocument res = this.tsf.CreateTSR(in);
        EndpointReferenceType epr = res.getCreateTSRResponse().getTsrReference();
        return new TSSClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
    }

    public TSSClient createTSS(Calendar initialTerminationTime) throws Exception {
        CreateTSRDocument in = CreateTSRDocument.Factory.newInstance();
        TerminationTimeDocument.TerminationTime tt = TerminationTimeDocument.TerminationTime.Factory.newInstance();
        tt.setCalendarValue(initialTerminationTime);
        in.addNewCreateTSR().setTerminationTime(tt);
        return this.createTSS(in);
    }

    public TSSClient createTSS() throws Exception {
        CreateTSRDocument in = CreateTSRDocument.Factory.newInstance();
        in.addNewCreateTSR();
        return this.createTSS(in);
    }

    public TargetSystemFactoryPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TargetSystemFactoryPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public boolean supportsReservation() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getSupportsReservation();
    }

    public boolean supportsVirtualImages() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getSupportsVirtualImages();
    }

    public List<EndpointReferenceType> getTargetSystems() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getTargetSystemReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error("Can't get target system list.", e);
            return null;
        }
    }

    public OperatingSystemType[] getOperatingSystems() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getOperatingSystemArray();
    }

    @Override
    public String[] getXlogins() {
        try {
            SecurityType secT = this.getSecurityInfo();
            if (secT == null) {
                return this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getXloginArray();
            }
            return super.getXlogins();
        }
        catch (Exception e) {
            logger.error("Can't get xlogins.", e);
            return null;
        }
    }

    @Override
    public String[] getXgroups() {
        try {
            String[] srs = null;
            SecurityType secT = this.getSecurityInfo();
            if (secT != null) {
                return super.getXgroups();
            }
            srs = this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getXgroupArray();
            return srs;
        }
        catch (Exception e) {
            logger.error("Can't get xgroups.", e);
            return null;
        }
    }

    public List<EndpointReferenceType> getAccessibleTargetSystems() {
        try {
            EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemFactoryProperties().getAccessibleTargetSystemReferenceArray();
            return Arrays.asList(eprs);
        }
        catch (Exception e) {
            logger.error("Can't get accessible target system list.", e);
            return null;
        }
    }
}

