/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import org.apache.xmlbeans.XmlException;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.unigrids.services.atomic.types.ServiceStatusDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BaseClientWithStatus
extends BaseUASClient {
    public BaseClientWithStatus(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
        this.setRetryDefaults();
    }

    public BaseClientWithStatus(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(epr.getAddress().getStringValue(), epr, sec);
        this.setRetryDefaults();
    }

    public ServiceStatusDocument getServiceStatusDocument() throws BaseFault, ResourceUnavailableFault, ResourceUnknownFault, ClientException {
        GetResourcePropertyDocument req = GetResourcePropertyDocument.Factory.newInstance();
        req.setGetResourceProperty(ServiceStatusDocument.type.getDocumentElementName());
        try {
            GetResourcePropertyResponseDocument res = this.rp.GetResourceProperty(req);
            ServiceStatusDocument o = ServiceStatusDocument.Factory.parse(WSUtilities.extractResourceProperty(res).newInputStream());
            if (o == null || o.getServiceStatus() == null) {
                return null;
            }
            return o;
        }
        catch (InvalidResourcePropertyQNameFault q) {
            return null;
        }
        catch (IOException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
        catch (XmlException ioe) {
            throw new ClientException("Could not parse reply from server.", ioe);
        }
    }

    public String getServiceStatus() throws Exception {
        ServiceStatusDocument ssd = this.getServiceStatusDocument();
        if (ssd != null) {
            return String.valueOf(this.getServiceStatusDocument().getServiceStatus().getState());
        }
        return null;
    }

    public String getServiceStatusMessage() throws Exception {
        ServiceStatusDocument ssd = this.getServiceStatusDocument();
        if (ssd != null) {
            return String.valueOf(this.getServiceStatusDocument().getServiceStatus().getDescription());
        }
        return null;
    }
}

