/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila;

import eu.unicore.hila.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocationPattern {
    private static final Logger log = Logger.getLogger(LocationPattern.class);
    private Pattern pattern = null;
    private List<String> variables = null;

    public LocationPattern(String templateString) {
        this.pattern = this.makePattern(templateString);
        log.debug((Object)this.pattern);
    }

    public boolean match(Location location) {
        CharSequence cs = location.getStringValue();
        Matcher m1 = this.pattern.matcher(cs);
        return m1.matches();
    }

    public Map<String, String> fillTemplates(Location location) {
        HashMap<String, String> templateVariables = new HashMap<String, String>();
        Matcher m = this.pattern.matcher(location.getStringValue());
        if (m.matches()) {
            log.debug((Object)("Expression " + m.pattern() + " matches " + location.getStringValue()));
            log.debug((Object)("" + m.groupCount() + " == " + this.variables.size() + " : " + (m.groupCount() == this.variables.size())));
            if (m.groupCount() == this.variables.size()) {
                int i = 1;
                for (String variable : this.variables) {
                    String value = m.group(i++);
                    templateVariables.put(variable, value);
                    log.debug((Object)("Put variable " + variable + " as " + value));
                }
            }
        }
        return templateVariables;
    }

    private Pattern makePattern(String templateString2) {
        Pattern pat = Pattern.compile("\\{[^{}@/]*\\}");
        Matcher m = pat.matcher(templateString2);
        this.variables = new ArrayList<String>();
        while (m.find()) {
            this.variables.add(m.group());
            log.debug((Object)("adding variable " + m.group()));
        }
        return Pattern.compile(m.replaceAll("([^{}/]+)"));
    }
}

