/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Time
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Time.class);

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        if (cmdArgs.length > 1) {
            ShellCommand command = ctx.getCommand(cmdArgs[1]);
            if (command != null) {
                ArrayList<String> cmdArgs2 = new ArrayList<String>();
                for (int i = 1; i < cmdArgs.length; ++i) {
                    cmdArgs2.add(cmdArgs[i]);
                }
                long startTime = System.currentTimeMillis();
                command.execute(cmdArgs2.toArray(new String[0]), ctx);
                long endTime = System.currentTimeMillis();
                String msg = "Execution of " + cmdArgs[1] + " took " + Long.toString(endTime - startTime) + "ms.";
                try {
                    ctx.getCs().printNewline();
                    ctx.getCs().printString(msg);
                    ctx.getCs().printNewline();
                }
                catch (IOException e) {
                    log.info((Object)msg);
                }
            }
        } else {
            log.error((Object)"Don't know which command to time.");
        }
    }
}

