/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import java.io.IOException;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public abstract class ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(ShellCommandBase.class);
    protected Options options = new Options();
    protected CommandLineParser parser = new PosixParser();

    @Override
    public String getName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder();
        for (Option option : this.options.getOptions()) {
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append("-".concat(option.getOpt()));
            if (option.getLongOpt() != null) {
                lineBuilder.append(", ");
                lineBuilder.append("--".concat(option.getLongOpt()));
            }
            lineBuilder.append("                                                  ");
            lineBuilder.insert(20, option.getDescription());
            lineBuilder.append(System.getProperty("line.separator"));
            sb.append((CharSequence)lineBuilder);
        }
        return sb.toString();
    }

    protected void missingArg(String string) {
    }

    protected void printHelp(ShellContext ctx) {
        String helpString = this.help();
        try {
            ctx.getCs().printString(helpString);
            ctx.getCs().printNewline();
        }
        catch (IOException e) {
            log.info((Object)helpString);
        }
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        throw new HiLANotImplementedException("Command not implemented.");
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

