/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Progressable;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Monitor
extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(Monitor.class);

    public Monitor() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.INTERVAL);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdLine;
        try {
            cmdLine = this.parser.parse(this.options, cmdArgs);
        }
        catch (ParseException e) {
            throw new HiLAException("Unable to parse command line.", (Throwable)e);
        }
        if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
            this.printHelp(ctx);
            return;
        }
        List argList = cmdLine.getArgList();
        argList.remove(0);
        if (argList.size() == 1) {
            String locStr = (String)argList.get(0);
            Location loc = new Location(locStr);
            if (!loc.isLocationOfType(Progressable.class)) {
                loc = ctx.getCurrentLocation().getChildLocation(locStr);
            }
            if (!loc.isLocationOfType(Progressable.class)) {
                throw new HiLAException("Location does not point ot a Progressable resource.");
            }
            long interval = 1000L;
            if (cmdLine.hasOption(OptionConstants.INTERVAL.getArgName())) {
                String intervalString = cmdLine.getOptionValue(OptionConstants.INTERVAL.getArgName());
                try {
                    interval = Long.parseLong(intervalString);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Cannot parse number from " + intervalString + ". Using default of 1000ms."), (Throwable)e);
                }
            }
            Progressable prog = (Progressable)loc.locate(new Object[0]);
            do {
                log.info((Object)(Long.toString(prog.getCurrent()) + "/" + Long.toString(prog.getMax()) + " " + prog.getUnit()));
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!prog.isDone());
        } else {
            throw new HiLAException("Can only monitor one progresable at a time.");
        }
    }
}

