/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.grid.Task;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Ls
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Ls.class);

    public Ls() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"l");
        OptionBuilder.withLongOpt((String)"detail");
        OptionBuilder.hasArg((boolean)false);
        this.options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
    }

    @Override
    public String getName() {
        return "ls";
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) {
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption("h")) {
                this.printHelp(ctx);
                return;
            }
            List locationStrings = cmdLine.getArgList();
            locationStrings.remove(0);
            if (locationStrings.size() == 0) {
                if (ctx.getCurrentLocation() != null) {
                    locationStrings.add(ctx.getCurrentLocation().toString());
                } else {
                    log.warn((Object)"No location given and no current location.");
                    return;
                }
            }
            for (String locactionString : locationStrings) {
                try {
                    Location loc = new Location(locactionString);
                    Resource res = null;
                    try {
                        res = loc.locate(new Object[0]);
                    }
                    catch (HiLALocationSyntaxException e) {
                        res = ctx.getCurrentLocation().getChildLocation(locactionString).locate(new Object[0]);
                    }
                    List children = res.getChildren();
                    for (Resource resource : children) {
                        this.printResourceLN(ctx, resource, cmdLine.hasOption("l"));
                    }
                    ctx.getCs().flushConsole();
                }
                catch (HiLAException e) {
                    log.error((Object)"Caught HiLAException.", (Throwable)e);
                }
                catch (Exception e) {
                    try {
                        ctx.getCs().printString("Caught " + e.toString() + " : " + e.getMessage());
                        ctx.getCs().printNewline();
                        ctx.getCs().flushConsole();
                    }
                    catch (IOException e1) {
                        System.err.println("Writing to ConsoleReader failed.");
                    }
                }
            }
        }
        catch (ParseException e2) {
            log.error((Object)"Unable to parse command line.", (Throwable)e2);
        }
    }

    private void printResourceLN(ShellContext ctx, Resource resource, boolean _detailed) {
        if (resource instanceof File && _detailed) {
            this.printFileResource(ctx, (File)resource);
        } else if (resource instanceof Task && _detailed) {
            this.printTaskResource(ctx, (Task)resource);
        } else {
            this.printResource(ctx, resource);
        }
        try {
            ctx.getCs().printNewline();
        }
        catch (IOException e) {
            log.error((Object)"Unable to print to console", (Throwable)e);
        }
    }

    private void printResource(ShellContext ctx, Resource resource) {
        try {
            ctx.getCs().printString(resource.getLocation().toString());
        }
        catch (IOException e) {
            log.info((Object)resource.getLocation().toString());
        }
    }

    private void printTaskResource(ShellContext ctx, Task task) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(task.getLocation().toString());
            sb.append("\t").append(task.status().toString());
            try {
                ctx.getCs().printString(sb.toString());
            }
            catch (IOException e) {
                log.info((Object)task.status().toString());
            }
        }
        catch (HiLAException e) {
            log.error((Object)(task.getLocation().toString() + "\t" + "status unavailable"), (Throwable)e);
        }
    }

    private void printFileResource(ShellContext ctx, File file) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        try {
            formatter.format(" %c%c%c%c %12d %s", Character.valueOf(file.isDirectory() ? (char)'d' : '-'), Character.valueOf(file.isReadable() ? (char)'r' : '-'), Character.valueOf(file.isWritable() ? (char)'w' : '-'), Character.valueOf(file.isExecutable() ? (char)'x' : '-'), file.size(), file.getLocation().toString());
            ctx.getCs().printString(sb.toString());
        }
        catch (HiLAException e) {
            log.error((Object)"Unable to query file properties.", (Throwable)e);
        }
        catch (IOException e) {
            log.info((Object)sb.toString(), (Throwable)e);
        }
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder();
        sb.append("ls -- list a location");
        sb.append(System.getProperty("line.separator"));
        sb.append("lists the current location if none is given,");
        sb.append("otherwise the given locations will be listed.");
        sb.append(System.getProperty("line.separator"));
        return sb.append(super.help()).toString();
    }
}

