/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ChMod
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(ChMod.class);

    public ChMod() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withDescription((String)"This help message.");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"r");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Set read permission to true/false");
        OptionBuilder.withLongOpt((String)"read");
        this.options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"w");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Set write permission to true/false");
        OptionBuilder.withLongOpt((String)"write");
        this.options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withArgName((String)"x");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Set executable permission to true/false");
        OptionBuilder.withLongOpt((String)"execute");
        this.options.addOption(OptionBuilder.create((String)"x"));
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            boolean setReadable = false;
            boolean readable = false;
            boolean setWritable = false;
            boolean writable = false;
            boolean setExecutable = false;
            boolean executable = false;
            CommandLine cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption("h")) {
                this.printHelp(ctx);
                return;
            }
            if (cmdline.hasOption("r")) {
                setReadable = true;
                readable = Boolean.parseBoolean(cmdline.getOptionValue("r"));
            }
            if (cmdline.hasOption("w")) {
                setWritable = true;
                writable = Boolean.parseBoolean(cmdline.getOptionValue("w"));
            }
            if (cmdline.hasOption("x")) {
                setExecutable = true;
                executable = Boolean.parseBoolean(cmdline.getOptionValue("x"));
            }
            List opts = cmdline.getArgList();
            opts.remove(0);
            if (opts.size() > 0) {
                for (String string : opts) {
                    try {
                        Location loc = new Location(string);
                        if (!loc.isLocationOfType(File.class)) {
                            loc = ctx.getCurrentLocation().getChildLocation(string);
                        }
                        if (loc.isLocationOfType(File.class)) {
                            File file = (File)loc.locate(new Object[0]);
                            if (setReadable) {
                                file.setIsReadable(readable);
                            }
                            if (setWritable) {
                                file.setIsWritable(writable);
                            }
                            if (!setExecutable) continue;
                            file.setIsExecutable(executable);
                            continue;
                        }
                        log.error((Object)"Cannot set permissions on non-file resource");
                    }
                    catch (HiLAException e) {
                        log.error((Object)("Setting permissions for " + string + " failed"), (Throwable)e);
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

