/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Task;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Abort
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Abort.class);

    public Abort() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.HELP);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdLine;
        try {
            cmdLine = this.parser.parse(this.options, cmdArgs);
        }
        catch (ParseException e) {
            throw new HiLAException("Unable to parse command line.", (Throwable)e);
        }
        if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
            this.printHelp(ctx);
            return;
        }
        List argList = cmdLine.getArgList();
        argList.remove(0);
        for (String taskLocStr : argList) {
            Location taskLoc = new Location(taskLocStr);
            if (!taskLoc.isLocationOfType(Task.class) && ctx.getCurrentLocation() != null) {
                taskLoc = ctx.getCurrentLocation().getChildLocation(taskLocStr);
            }
            if (!taskLoc.isLocationOfType(Task.class)) {
                log.error((Object)(taskLoc.toString() + " is not a Location of type " + Task.class.getName()));
            }
            Task task = (Task)taskLoc.locate(new Object[0]);
            try {
                task.abort();
            }
            catch (HiLAException e) {
                log.error((Object)("Unable to abort Task: " + taskLoc.toString()), (Throwable)e);
            }
        }
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder();
        sb.append("Abort a running task, e.g. ComputeTask, Import, Export, Transfer");
        sb.append(System.getProperty("line.separator"));
        sb.append(System.getProperty("line.separator"));
        sb.append(super.help());
        return sb.toString();
    }
}

