/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.shell.commands.ShellCommand;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jline.ConsoleReader;

public class ShellContext {
    private Location currentLocation = null;
    private File currentLocalDir = null;
    private boolean isDone = false;
    private ConsoleReader cs = null;
    private final Map<String, ShellCommand> commands = new HashMap<String, ShellCommand>();
    private final Map<String, String> aliases;

    public ConsoleReader getCs() {
        return this.cs;
    }

    public void setDone(boolean isDone) {
        this.isDone = isDone;
    }

    public ShellContext(ConsoleReader _cs) throws HiLALocationSyntaxException {
        this.currentLocation = new Location("");
        this.currentLocalDir = new File("").getAbsoluteFile();
        this.cs = _cs;
        this.aliases = new HashMap<String, String>();
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(Location currentLocation) {
        this.currentLocation = currentLocation;
    }

    public File getCurrentLocalDir() {
        return this.currentLocalDir;
    }

    public void setCurrentLocalDir(File currentLocalDir) {
        this.currentLocalDir = currentLocalDir;
    }

    public ShellCommand getCommand(String _cmd) {
        return this.commands.get(_cmd);
    }

    public void registerCommand(String _cmdName, ShellCommand _cmd) {
        this.commands.put(_cmdName, _cmd);
    }

    public void registerCommand(ShellCommand _cmd) {
        this.commands.put(_cmd.getName(), _cmd);
    }

    public boolean isDone() {
        return this.isDone;
    }

    public Collection<String> getCommands() {
        return this.commands.keySet();
    }

    public boolean isAlias(String string) {
        return this.aliases.containsKey(string);
    }

    public String getAlias(String string) {
        return this.aliases.get(string);
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }
}

