/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.http;

import java.io.IOException;
import java.io.OutputStream;

public class HTTPChunkedOutputStream
extends OutputStream {
    protected boolean closed = false;
    protected int count;
    protected byte[] buf;
    protected OutputStream out;

    public HTTPChunkedOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public HTTPChunkedOutputStream(OutputStream out, int size) {
        this.out = out;
        this.buf = new byte[size];
        this.count = 0;
    }

    private void flushBuffer(boolean flush) throws IOException {
        String chunkLength = Integer.toString(this.count, 16);
        this.out.write(chunkLength.getBytes());
        this.out.write("\r\n".getBytes());
        this.out.write(this.buf, 0, this.count);
        this.out.write("\r\n".getBytes());
        this.count = 0;
        if (flush) {
            this.out.flush();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkNotClosed();
        if (this.count >= this.buf.length) {
            this.flushBuffer(false);
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.count > 0) {
            this.flushBuffer(true);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.flushBuffer(true);
        this.closed = true;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        int remaining = len;
        int sofar = 0;
        while (remaining > 0) {
            int roomInBuf = this.buf.length - this.count;
            int lenToWrite = Math.min(roomInBuf, len);
            System.arraycopy(b, sofar + off, this.buf, this.count, lenToWrite);
            sofar += lenToWrite;
            this.count += lenToWrite;
            remaining -= lenToWrite;
            if (this.count < this.buf.length) continue;
            this.flushBuffer(false);
        }
    }
}

