/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];

    static {
        int i = 0;
        while (i < 255) {
            Base64.base64Alphabet[i] = -1;
            ++i;
        }
        i = 90;
        while (i >= 65) {
            Base64.base64Alphabet[i] = (byte)(i - 65);
            --i;
        }
        i = 122;
        while (i >= 97) {
            Base64.base64Alphabet[i] = (byte)(i - 97 + 26);
            --i;
        }
        i = 57;
        while (i >= 48) {
            Base64.base64Alphabet[i] = (byte)(i - 48 + 52);
            --i;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
    }

    public static boolean isBase64(String isValidString) {
        return Base64.isArrayByteBase64(isValidString.getBytes());
    }

    public static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }

    public static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = arrayOctect.length;
        if (length == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (!Base64.isBase64(arrayOctect[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] encode(byte[] binaryData) {
        return org.bouncycastle.util.encoders.Base64.encode(binaryData);
    }

    public static byte[] decode(byte[] base64Data) {
        return org.bouncycastle.util.encoders.Base64.decode(base64Data);
    }
}

