/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.globus.rsl.Bindings;
import org.globus.rsl.NameOpValue;
import org.globus.rsl.RslEvaluationException;

public abstract class AbstractRslNode {
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int MULTI = 3;
    protected int _operator;
    protected List _specifications;

    public AbstractRslNode() {
        this.setOperator(1);
    }

    public AbstractRslNode(int operator) {
        this.setOperator(operator);
    }

    public abstract boolean add(Bindings var1);

    public abstract boolean add(NameOpValue var1);

    public boolean add(AbstractRslNode node) {
        if (this._specifications == null) {
            this._specifications = new LinkedList();
        }
        return this._specifications.add(node);
    }

    public abstract NameOpValue getParam(String var1);

    public abstract Bindings getBindings(String var1);

    public boolean removeSpecification(AbstractRslNode node) {
        if (this._specifications == null || node == null) {
            return false;
        }
        return this._specifications.remove(node);
    }

    public abstract Bindings removeBindings(String var1);

    public abstract NameOpValue removeParam(String var1);

    public void merge(AbstractRslNode inNode) {
        inNode.mergeTo(this);
    }

    public void mergeTo(AbstractRslNode dstNode) {
        Iterator iter = null;
        if (this._specifications != null) {
            for (AbstractRslNode node : this._specifications) {
                dstNode.add(node);
            }
        }
    }

    public List getSpecifications() {
        return this._specifications;
    }

    public int getOperator() {
        return this._operator;
    }

    public void setOperator(int oper) {
        this._operator = oper;
    }

    public String getOperatorAsString() {
        return AbstractRslNode.getOperatorAsString(this._operator);
    }

    public static String getOperatorAsString(int op) {
        switch (op) {
            case 1: {
                return "&";
            }
            case 3: {
                return "+";
            }
            case 2: {
                return "|";
            }
        }
        return "??";
    }

    public AbstractRslNode evaluate() throws RslEvaluationException {
        return this.evaluate(null);
    }

    public abstract AbstractRslNode evaluate(Map var1) throws RslEvaluationException;

    public String toRSL(boolean explicitConcat) {
        StringBuffer buf = new StringBuffer();
        this.toRSL(buf, explicitConcat);
        return buf.toString();
    }

    public abstract void toRSL(StringBuffer var1, boolean var2);

    public String toString() {
        return this.toRSL(true);
    }

    public static String canonicalize(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char ch = str.charAt(i);
            if (ch != '_') {
                buf.append(Character.toLowerCase(ch));
            }
            ++i;
        }
        return buf.toString();
    }
}

