/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;

public class JndiTest {
    public static void main(String[] args) {
        block33: {
            String host = null;
            String binddn = null;
            String baseDN = "mds-vo-name=local, o=grid";
            String filter = "(objectclass=*)";
            String qop = "auth-conf, auth";
            boolean debug = false;
            int port = 389;
            int version = 3;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-h")) {
                    host = args[++i];
                } else if (args[i].equals("-p")) {
                    port = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-ver")) {
                    version = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-d")) {
                    debug = true;
                } else if (args[i].equals("-D")) {
                    binddn = args[++i];
                } else if (args[i].equals("-b")) {
                    baseDN = args[++i];
                } else if (args[i].equals("-qop")) {
                    qop = args[++i];
                } else if (args[i].equalsIgnoreCase("-usage") || args[i].equalsIgnoreCase("-help")) {
                    System.err.println("Usage: JndiTest -h [host] -p [port] -D [binddn] [-d] -b [baseDN]");
                    System.err.println("\tExample: JndiTest -h mds.globus.org -p 389 -r o=globus,c=us");
                    System.exit(1);
                } else {
                    System.err.println("Invalid argument: " + args[i]);
                    System.exit(1);
                }
                ++i;
            }
            if (host == null) {
                System.err.println("Error: hostname not specified!");
                System.exit(1);
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.ldap.version", String.valueOf(version));
            env.put("java.naming.provider.url", "ldap://" + host + ":" + port);
            env.put("java.naming.security.authentication", "GSS-OWNYQ6NTEOAUVGWG");
            env.put("javax.security.sasl.client.pkgs", "org.globus.mds.gsi.jndi");
            env.put("javax.security.sasl.qop", qop);
            if (binddn != null) {
                env.put("java.naming.security.principal", binddn);
            }
            if (debug) {
                env.put("com.sun.jndi.ldap.trace.ber", System.err);
            }
            InitialDirContext ctx = null;
            try {
                try {
                    ctx = new InitialDirContext(env);
                    NamingEnumeration<SearchResult> results = ctx.search(baseDN, filter, null);
                    while (results.hasMoreElements()) {
                        SearchResult si = results.next();
                        Attributes attrs = si.getAttributes();
                        System.out.println(String.valueOf(si.getName()) + ":");
                        System.out.println(attrs);
                        System.out.println();
                    }
                }
                catch (Exception e) {
                    System.err.println("JndiTest failed: " + e.getMessage());
                    e.printStackTrace();
                    if (ctx == null) break block33;
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

