/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds;

import org.globus.mds.MDS;
import org.globus.mds.MDSException;
import org.globus.mds.MDSResult;

public class MDSTest2 {
    private int errorCount = 0;
    MDSResult mdsResult;

    public void displayAttributes(MDS mds, String dn) {
        try {
            MDSResult mdsResult = mds.getAttributes(dn);
            mdsResult.print();
            System.out.println();
        }
        catch (MDSException e) {
            System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
            ++this.errorCount;
        }
    }

    public void run(String host, String port, String userdn, String userpwd, String bdn) {
        MDS mds = new MDS(host, port);
        try {
            try {
                mds.connect(userdn, userpwd);
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            try {
                this.mdsResult = mds.getAttributes(bdn);
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            this.mdsResult.print();
            this.mdsResult.remove("dn");
            this.mdsResult.add("testfield", new String[]{"value1", "value2", "value3"});
            try {
                mds.updateEntry(bdn, this.mdsResult);
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            System.out.println();
            this.displayAttributes(mds, bdn);
            MDSResult a3 = new MDSResult();
            a3.add("testfield", "value2");
            try {
                mds.deleteValues(bdn, a3);
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            this.displayAttributes(mds, bdn);
            try {
                mds.deleteAttribute(bdn, "testfield");
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            this.displayAttributes(mds, bdn);
        }
        finally {
            try {
                mds.disconnect();
            }
            catch (MDSException mDSException) {}
        }
    }

    public void printResults() {
        if (this.errorCount == 0) {
            System.out.println("{test} MDS TEST 2: succeeded");
        } else {
            System.out.println("{test} MDS TEST 2: failed -- " + this.errorCount + " error(s) encountered");
        }
    }

    public static void main(String[] argv) {
        if (argv.length < 5) {
            System.err.println("Usage: java MDSTest2 host port userdn userpwd dn");
            System.exit(-1);
        }
        MDSTest2 mdsTest = new MDSTest2();
        mdsTest.run(argv[0], argv[1], argv[2], argv[3], argv[4]);
        mdsTest.printResults();
    }
}

