/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.urlcopy;

import org.globus.io.urlcopy.TransferListener;
import org.globus.io.urlcopy.UrlCopy;
import org.globus.util.GlobusURL;

public class UrlCopyTest {
    private static String[] inurls = new String[]{"http://www-unix.mcs.anl.gov/~gawor/index.html", "ftp://charlie.iit.edu/pub/IMC/gleeclub_big.gif", "gsiftp://dg0n1.mcs.anl.gov/testdata/globus_io_common.c"};
    private static String outurl = "gsiftp://dg0n1.mcs.anl.gov/testdata/";
    private static TransferListener l = new TransferListener();

    public static void run() {
        int i = 0;
        while (i < inurls.length) {
            UrlCopyTest.url2FileCopy(inurls[i], "file:///", i);
            ++i;
        }
        i = 0;
        while (i < inurls.length) {
            UrlCopyTest.url2FileCopy(inurls[i], outurl, i + 1);
            ++i;
        }
    }

    private static void url2FileCopy(String fromu, String base, int i) {
        try {
            GlobusURL from = new GlobusURL(fromu);
            GlobusURL to = new GlobusURL(String.valueOf(base) + "transfertest." + from.getProtocol() + "." + (i + 1));
            System.out.println("Copying...");
            System.out.println(" From: " + from.getURL());
            System.out.println("   To: " + to.getURL());
            long st = System.currentTimeMillis();
            UrlCopy c = new UrlCopy();
            c.setSourceUrl(from);
            c.setDestinationUrl(to);
            c.setUseThirdPartyCopy(true);
            c.addUrlCopyListener(l);
            c.run();
            long ft = System.currentTimeMillis();
            System.out.println("Done: " + (ft - st));
        }
        catch (Exception e) {
            System.err.println("Copy failed:" + e.getMessage());
        }
    }

    public static void main(String[] argv) {
        UrlCopyTest.run();
    }
}

