/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.ptls;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.ptls.PureTLSUtil;

public class PureTLSTrustedCertificates
extends TrustedCertificates {
    private static Log logger = LogFactory.getLog(PureTLSTrustedCertificates.class.getName());
    private static PureTLSTrustedCertificates ptlsCerts = null;
    private TrustedCertificates tc;
    private Vector certList = null;

    protected PureTLSTrustedCertificates() {
    }

    public PureTLSTrustedCertificates(TrustedCertificates tc) {
        this.tc = tc;
    }

    protected void setTrustedCertificates(TrustedCertificates tc) {
        this.tc = tc;
    }

    @Override
    public X509Certificate[] getCertificates() {
        return this.tc.getCertificates();
    }

    @Override
    public X509Certificate getCertificate(String subject) {
        return this.tc.getCertificate(subject);
    }

    @Override
    public SigningPolicy[] getSigningPolicies() {
        return this.tc.getSigningPolicies();
    }

    @Override
    public SigningPolicy getSigningPolicy(String subject) {
        return this.tc.getSigningPolicy(subject);
    }

    @Override
    public void refresh() {
        this.reload(null);
    }

    @Override
    public synchronized void reload(String locations) {
        this.tc.reload(locations);
    }

    @Override
    public synchronized Vector getX509CertList() {
        if (this.tc.isChanged() || this.certList == null) {
            try {
                this.certList = PureTLSUtil.certificateChainToVector(this.getCertificates());
            }
            catch (GeneralSecurityException e) {
                logger.debug("Failed to convert certificates", e);
            }
        }
        return this.certList;
    }

    public static synchronized PureTLSTrustedCertificates getDefaultPureTLSTrustedCertificates() {
        if (ptlsCerts == null) {
            ptlsCerts = new PureTLSTrustedCertificates();
        }
        ptlsCerts.setTrustedCertificates(TrustedCertificates.getDefault());
        return ptlsCerts;
    }
}

