/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.proxy;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.CertificateException;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.ptls.PureTLSUtil;
import org.globus.util.I18n;

public class ProxyPathValidator {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.proxy.errors", ProxyPathValidator.class.getClassLoader());
    private static Log logger = LogFactory.getLog(ProxyPathValidator.class.getName());
    private boolean rejectLimitedProxyCheck = false;
    private boolean limited = false;
    private X509Certificate identityCert = null;
    private Hashtable proxyPolicyHandlers = null;

    public boolean isLimited() {
        return this.limited;
    }

    public X509Certificate getIdentityCertificate() {
        return this.identityCert;
    }

    public String getIdentity() {
        return BouncyCastleUtil.getIdentity(this.identityCert);
    }

    public ProxyPolicyHandler removeProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.remove(id) : null;
    }

    public ProxyPolicyHandler setProxyPolicyHandler(String id, ProxyPolicyHandler handler) {
        if (id == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyPolicyId"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(i18n.getMessage("proxyPolicyHandler"));
        }
        if (this.proxyPolicyHandlers == null) {
            this.proxyPolicyHandlers = new Hashtable();
        }
        return this.proxyPolicyHandlers.put(id, handler);
    }

    public ProxyPolicyHandler getProxyPolicyHandler(String id) {
        return id != null && this.proxyPolicyHandlers != null ? (ProxyPolicyHandler)this.proxyPolicyHandlers.get(id) : null;
    }

    public void reset() {
        this.rejectLimitedProxyCheck = false;
        this.limited = false;
        this.identityCert = null;
    }

    public void setRejectLimitedProxyCheck(boolean rejectLimProxy) {
        this.rejectLimitedProxyCheck = rejectLimProxy;
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, crls, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls, SigningPolicy[] signingPolicies) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, crls, signingPolicies, null);
    }

    public void validate(X509Certificate[] certPath, X509Certificate[] trustedCerts, CertificateRevocationLists crls, SigningPolicy[] signingPolicies, Boolean enforceSigningPolicy) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException(i18n.getMessage("certsNull"));
        }
        TrustedCertificates trustedCertificates = null;
        if (trustedCerts != null) {
            trustedCertificates = new TrustedCertificates(trustedCerts, signingPolicies);
        }
        Vector validatedChain = null;
        CertVerifyPolicyInt policy = PureTLSUtil.getDefaultCertVerifyPolicy();
        try {
            Vector userCerts = PureTLSUtil.certificateChainToVector(certPath);
            CertContext context = new CertContext();
            if (trustedCerts != null) {
                int i = 0;
                while (i < trustedCerts.length) {
                    context.addRoot(trustedCerts[i].getEncoded());
                    ++i;
                }
            }
            validatedChain = X509Cert.verifyCertChain(context, userCerts, policy);
        }
        catch (CertificateException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        if (validatedChain == null || validatedChain.size() < certPath.length) {
            String err = i18n.getMessage("unknownCA");
            throw new ProxyPathValidatorException(4, null, err);
        }
        int size = validatedChain.size();
        if (size != certPath.length) {
            X509Certificate[] newCertPath = new X509Certificate[size];
            System.arraycopy(certPath, 0, newCertPath, 0, certPath.length);
            try {
                int i = 0;
                while (i < size - certPath.length) {
                    X509Cert cert = (X509Cert)validatedChain.elementAt(i);
                    ByteArrayInputStream in = new ByteArrayInputStream(cert.getDER());
                    newCertPath[i + certPath.length] = CertUtil.loadCertificate(in);
                    ++i;
                }
            }
            catch (GeneralSecurityException e) {
                throw new ProxyPathValidatorException(-1, (Throwable)e);
            }
            certPath = newCertPath;
        }
        this.validate(certPath, trustedCertificates, crls, enforceSigningPolicy);
    }

    protected void validate(X509Certificate[] certPath) throws ProxyPathValidatorException {
        this.validate(certPath, (TrustedCertificates)null, (CertificateRevocationLists)null);
    }

    protected void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, null);
    }

    protected void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts, CertificateRevocationLists crlsList) throws ProxyPathValidatorException {
        this.validate(certPath, trustedCerts, null, null);
    }

    protected void validate(X509Certificate[] certPath, TrustedCertificates trustedCerts, CertificateRevocationLists crlsList, Boolean enforceSigningPolicy) throws ProxyPathValidatorException {
        if (certPath == null) {
            throw new IllegalArgumentException(i18n.getMessage("certsNull"));
        }
        if (crlsList == null) {
            crlsList = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        }
        if (trustedCerts == null) {
            trustedCerts = TrustedCertificates.getDefaultTrustedCertificates();
        }
        int proxyDepth = 0;
        try {
            X509Certificate cert = certPath[0];
            TBSCertificateStructure tbsCert = BouncyCastleUtil.getTBSCertificateStructure(cert);
            int certType = BouncyCastleUtil.getCertificateType(tbsCert, trustedCerts);
            if (logger.isDebugEnabled()) {
                logger.debug("Found cert: " + certType);
            }
            if (logger.isTraceEnabled()) {
                logger.debug(cert);
            }
            this.checkValidity(cert);
            this.checkUnsupportedCriticalExtensions(tbsCert, certType, cert);
            this.checkIdentity(cert, certType);
            this.checkCRL(cert, crlsList, trustedCerts);
            if (this.requireSigningPolicyCheck(certType)) {
                this.checkSigningPolicy(cert, trustedCerts, enforceSigningPolicy);
            }
            if (CertUtil.isProxy(certType)) {
                ++proxyDepth;
            }
            int i = 1;
            while (i < certPath.length) {
                X509Certificate issuerCert = certPath[i];
                TBSCertificateStructure issuerTbsCert = BouncyCastleUtil.getTBSCertificateStructure(issuerCert);
                int issuerCertType = BouncyCastleUtil.getCertificateType(issuerTbsCert, trustedCerts);
                if (logger.isDebugEnabled()) {
                    logger.debug("Found cert: " + issuerCertType);
                }
                if (logger.isTraceEnabled()) {
                    logger.debug(issuerCert);
                }
                if (issuerCertType == 4) {
                    if (CertUtil.isProxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, i18n.getMessage("proxyErr00"));
                    }
                    int pathLen = this.getCAPathConstraint(issuerTbsCert);
                    if (pathLen >= 0 && pathLen < Integer.MAX_VALUE && i - proxyDepth - 1 > pathLen) {
                        throw new ProxyPathValidatorException(3, issuerCert, i18n.getMessage("proxyErr01", new String[]{Integer.toString(pathLen), Integer.toString(i - proxyDepth - 1)}));
                    }
                } else if (CertUtil.isGsi3Proxy(issuerCertType) || CertUtil.isGsi4Proxy(issuerCertType)) {
                    String errMsg = i18n.getMessage("proxyErr02");
                    if (CertUtil.isGsi3Proxy(issuerCertType) ? !CertUtil.isGsi3Proxy(certType) : CertUtil.isGsi4Proxy(issuerCertType) && !CertUtil.isGsi4Proxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, errMsg);
                    }
                    int pathLen = BouncyCastleUtil.getProxyPathConstraint(issuerTbsCert);
                    if (pathLen == 0) {
                        throw new ProxyPathValidatorException(-1, issuerCert, i18n.getMessage("proxyErr03"));
                    }
                    if (pathLen < Integer.MAX_VALUE && proxyDepth > pathLen) {
                        throw new ProxyPathValidatorException(3, issuerCert, i18n.getMessage("proxyErr04", new String[]{Integer.toString(pathLen), Integer.toString(proxyDepth)}));
                    }
                    ++proxyDepth;
                } else if (CertUtil.isGsi2Proxy(issuerCertType)) {
                    if (!CertUtil.isGsi2Proxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, i18n.getMessage("proxyErr02"));
                    }
                    ++proxyDepth;
                } else if (issuerCertType == 3) {
                    if (!CertUtil.isProxy(certType)) {
                        throw new ProxyPathValidatorException(-1, issuerCert, i18n.getMessage("proxyErr05"));
                    }
                } else {
                    throw new ProxyPathValidatorException(-1, issuerCert, i18n.getMessage("proxyErr06", Integer.toString(issuerCertType)));
                }
                if (CertUtil.isProxy(certType)) {
                    if (CertUtil.isGsi3Proxy(certType) || CertUtil.isGsi4Proxy(certType)) {
                        this.checkProxyConstraints(tbsCert, issuerTbsCert, cert);
                        if (certType == 12 || certType == 16) {
                            this.checkRestrictedProxy(tbsCert, certPath, i - 1);
                        }
                    }
                } else {
                    this.checkKeyUsage(issuerTbsCert, certPath, i);
                }
                this.checkValidity(issuerCert);
                this.checkUnsupportedCriticalExtensions(issuerTbsCert, issuerCertType, issuerCert);
                this.checkIdentity(issuerCert, issuerCertType);
                this.checkCRL(cert, crlsList, trustedCerts);
                if (this.requireSigningPolicyCheck(certType)) {
                    this.checkSigningPolicy(cert, trustedCerts, enforceSigningPolicy);
                }
                cert = issuerCert;
                certType = issuerCertType;
                tbsCert = issuerTbsCert;
                ++i;
            }
        }
        catch (IOException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
        catch (ProxyPathValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProxyPathValidatorException(-1, (Throwable)e);
        }
    }

    protected void checkIdentity(X509Certificate cert, int certType) throws ProxyPathValidatorException {
        if (this.identityCert == null) {
            if (CertUtil.isLimitedProxy(certType)) {
                this.limited = true;
                if (this.rejectLimitedProxyCheck) {
                    throw new ProxyPathValidatorException(7, cert, i18n.getMessage("limitedProxy"));
                }
            }
            if (!CertUtil.isImpersonationProxy(certType)) {
                this.identityCert = cert;
            }
        }
    }

    protected void checkRestrictedProxy(TBSCertificateStructure proxy, X509Certificate[] certPath, int index) throws ProxyPathValidatorException, IOException {
        logger.debug("enter: checkRestrictedProxy");
        ProxyCertInfo info = BouncyCastleUtil.getProxyCertInfo(proxy);
        if (info == null) {
            throw new ProxyPathValidatorException(-1, certPath[index], i18n.getMessage("proxyErr07"));
        }
        ProxyPolicy policy = info.getProxyPolicy();
        if (policy == null) {
            throw new ProxyPathValidatorException(-1, certPath[index], i18n.getMessage("proxyErr08"));
        }
        String pl = policy.getPolicyLanguage().getId();
        ProxyPolicyHandler handler = this.getProxyPolicyHandler(pl);
        if (handler == null) {
            throw new ProxyPathValidatorException(5, certPath[index], i18n.getMessage("proxyErr09", pl));
        }
        handler.validate(info, certPath, index);
        logger.debug("exit: checkRestrictedProxy");
    }

    protected void checkKeyUsage(TBSCertificateStructure issuer, X509Certificate[] certPath, int index) throws ProxyPathValidatorException, IOException {
        logger.debug("enter: checkKeyUsage");
        boolean[] issuerKeyUsage = this.getKeyUsage(issuer);
        if (issuerKeyUsage != null && !issuerKeyUsage[5]) {
            throw new ProxyPathValidatorException(-1, certPath[index], i18n.getMessage("proxyErr10"));
        }
        logger.debug("exit: checkKeyUsage");
    }

    protected void checkProxyConstraints(TBSCertificateStructure proxy, TBSCertificateStructure issuer, X509Certificate checkedProxy) throws ProxyPathValidatorException, IOException {
        X509Extension ext;
        DERObjectIdentifier oid;
        Enumeration e;
        logger.debug("enter: checkProxyConstraints");
        X509Extension proxyKeyUsage = null;
        X509Extensions extensions = proxy.getExtensions();
        if (extensions != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                ext = extensions.getExtension(oid);
                if (oid.equals(X509Extensions.SubjectAlternativeName) || oid.equals(X509Extensions.IssuerAlternativeName)) {
                    throw new ProxyPathValidatorException(1, checkedProxy, i18n.getMessage("proxyErr11"));
                }
                if (oid.equals(X509Extensions.BasicConstraints)) {
                    BasicConstraints basicExt = BouncyCastleUtil.getBasicConstraints(ext);
                    if (!basicExt.isCA()) continue;
                    throw new ProxyPathValidatorException(1, checkedProxy, i18n.getMessage("proxyErr12"));
                }
                if (!oid.equals(X509Extensions.KeyUsage)) continue;
                proxyKeyUsage = ext;
                boolean[] keyUsage = BouncyCastleUtil.getKeyUsage(ext);
                if (!keyUsage[1] && !keyUsage[5]) continue;
                throw new ProxyPathValidatorException(1, checkedProxy, i18n.getMessage("proxyErr13"));
            }
        }
        if ((extensions = issuer.getExtensions()) != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                ext = extensions.getExtension(oid);
                if (!oid.equals(X509Extensions.KeyUsage)) continue;
                if (proxyKeyUsage == null) {
                    throw new ProxyPathValidatorException(1, checkedProxy, i18n.getMessage("proxyErr14"));
                }
                if (!ext.isCritical() || proxyKeyUsage.isCritical()) continue;
                throw new ProxyPathValidatorException(1, checkedProxy, i18n.getMessage("proxy15"));
            }
        }
        logger.debug("exit: checkProxyConstraints");
    }

    protected void checkUnsupportedCriticalExtensions(TBSCertificateStructure crt, int certType, X509Certificate checkedProxy) throws ProxyPathValidatorException {
        logger.debug("enter: checkUnsupportedCriticalExtensions");
        X509Extensions extensions = crt.getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (!ext.isCritical() || oid.equals(X509Extensions.BasicConstraints) || oid.equals(X509Extensions.KeyUsage) || oid.equals(ProxyCertInfo.OID) && CertUtil.isGsi4Proxy(certType) || oid.equals(ProxyCertInfo.OLD_OID) && CertUtil.isGsi3Proxy(certType)) continue;
                throw new ProxyPathValidatorException(2, checkedProxy, i18n.getMessage("proxyErr16", oid.getId()));
            }
        }
        logger.debug("exit: checkUnsupportedCriticalExtensions");
    }

    protected void checkValidity(X509Certificate cert) throws ProxyPathValidatorException {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            String msg = i18n.getMessage("proxyErr17", new Object[]{cert.getSubjectDN().getName(), ProxyPathValidatorException.getDateAsString(cert.getNotAfter()), ProxyPathValidatorException.getDateAsString(new Date())});
            throw new ProxyPathValidatorException(-1, cert, msg);
        }
        catch (CertificateNotYetValidException e) {
            Date date = new Date();
            String msg = i18n.getMessage("proxyErr18", new Object[]{cert.getSubjectDN().getName(), ProxyPathValidatorException.getDateAsString(cert.getNotBefore()), ProxyPathValidatorException.getDateAsString(new Date())});
            throw new ProxyPathValidatorException(-1, cert, msg);
        }
    }

    protected int getCAPathConstraint(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return -1;
        }
        X509Extension ext = extensions.getExtension(X509Extensions.BasicConstraints);
        if (ext != null) {
            BasicConstraints basicExt = BouncyCastleUtil.getBasicConstraints(ext);
            if (basicExt.isCA()) {
                BigInteger pathLen = basicExt.getPathLenConstraint();
                return pathLen == null ? Integer.MAX_VALUE : pathLen.intValue();
            }
            return -1;
        }
        return -1;
    }

    protected boolean[] getKeyUsage(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension ext = extensions.getExtension(X509Extensions.KeyUsage);
        return ext != null ? BouncyCastleUtil.getKeyUsage(ext) : null;
    }

    protected void checkCRL(X509Certificate cert, CertificateRevocationLists crlsList, TrustedCertificates trustedCerts) throws ProxyPathValidatorException {
        if (crlsList == null) {
            return;
        }
        logger.debug("checkCRLs: enter");
        if (trustedCerts == null) {
            String err = i18n.getMessage("proxyErr19");
            logger.error(err);
            throw new ProxyPathValidatorException(-1, null, err);
        }
        String issuerName = cert.getIssuerDN().getName();
        X509CRL crl = crlsList.getCrl(issuerName);
        if (crl == null) {
            logger.debug("No CRL for certificate");
            return;
        }
        X509Certificate x509Cert = trustedCerts.getCertificate(issuerName);
        if (x509Cert == null) {
            logger.debug("No trusted cert with this CA signature");
            return;
        }
        try {
            crl.verify(x509Cert.getPublicKey());
        }
        catch (Exception exp) {
            String err = i18n.getMessage("proxyErr20");
            logger.error(err);
            throw new ProxyPathValidatorException(-1, err, exp);
        }
        boolean validCRL = this.checkCRLValidity(crl);
        if (validCRL) {
            if (crl.isRevoked(cert)) {
                throw new ProxyPathValidatorException(6, cert, i18n.getMessage("proxyErr21", cert.getSubjectDN().getName()));
            }
        } else {
            throw new ProxyPathValidatorException(8, cert, i18n.getMessage("proxyErr36", issuerName));
        }
        logger.debug("checkCRLs: exit");
    }

    protected boolean checkCRLValidity(X509CRL crl) {
        Date now = new Date();
        return crl.getThisUpdate().before(now) && crl.getNextUpdate() != null && crl.getNextUpdate().after(now);
    }

    protected void checkSigningPolicy(X509Certificate certificate, TrustedCertificates trustedCerts, Boolean enforceSigningPolicy) throws ProxyPathValidatorException {
        boolean enforcePolicy = true;
        enforcePolicy = enforceSigningPolicy != null ? enforceSigningPolicy.booleanValue() : CoGProperties.getDefault().enforceSigningPolicy();
        if (!enforcePolicy) {
            return;
        }
        String issuerName = certificate.getIssuerDN().getName();
        String issuerGlobusId = CertUtil.toGlobusID(issuerName, true);
        SigningPolicy policy = trustedCerts.getSigningPolicy(issuerGlobusId);
        if (policy == null) {
            String err = i18n.getMessage("proxyErr33", issuerGlobusId);
            throw new ProxyPathValidatorException(9, err, null);
        }
        String certDN = certificate.getSubjectDN().toString();
        String certDNGlobus = CertUtil.toGlobusID(certDN, true);
        if (policy.isPolicyAvailable()) {
            boolean isValidDN = policy.isValidSubject(certDNGlobus);
            if (!isValidDN) {
                String err = i18n.getMessage("proxyErr34", new Object[]{certDNGlobus, issuerGlobusId, policy.getFileName()});
                throw new ProxyPathValidatorException(11, err, null);
            }
        } else {
            String err = i18n.getMessage("proxyErr35", new Object[]{issuerGlobusId, policy.getFileName()});
            throw new ProxyPathValidatorException(10, err, null);
        }
    }

    private boolean requireSigningPolicyCheck(int certType) {
        return !CertUtil.isProxy(certType) && certType != 4;
    }
}

