/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.example;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.gssapi.example.GetOpts;
import org.globus.net.SocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class GssClient {
    private static final String helpMsg = "Where options are:\n -gss-mode mode\t\t\tmode is: 'ssl' or 'gsi' (default)\n -deleg-type type\t\ttype is: 'none', 'limited' (default), or 'full'\n -lifetime time\t\t\tLifetime of context. time is in seconds.\n -rejectLimitedProxy\t\tEnables checking for limited proxies (off by default)\n -anonymous\t\t\tDo not send certificates to the server\n  -enable-conf\t\t\tEnables confidentiality (do encryption) (enabled by default)\n -disable-conf\t\t\tDisables confidentiality (no encryption)\n -auth auth\t\t\tIf auth is 'host' host authorization will be performed.\n           \t\t\tIf auth is 'self' self authorization will be performed.\n           \t\t\tOtherwise, identity authorization is performed.\n           \t\t\tAuthorization is not performed by default.";

    public static void main(String[] args) {
        block25: {
            String usage = "Usage: java GssClient [options] host port";
            GetOpts opts = new GetOpts(usage, helpMsg);
            int pos = opts.parse(args);
            if (pos + 2 > args.length) {
                System.err.println(usage);
                return;
            }
            String host = args[pos];
            int port = Integer.parseInt(args[pos + 1]);
            GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
            GSSContext context = null;
            Socket s = null;
            try {
                try {
                    s = SocketFactory.getDefault().createSocket(host, port);
                    OutputStream out = s.getOutputStream();
                    InputStream in = s.getInputStream();
                    byte[] inToken = new byte[]{};
                    byte[] outToken = null;
                    GSSName targetName = null;
                    if (opts.auth != null) {
                        targetName = opts.auth.equals("host") ? ((GSSManager)manager).createName("host@" + host, GSSName.NT_HOSTBASED_SERVICE) : (opts.auth.equals("self") ? ((GSSManager)manager).createCredential(1).getName() : ((GSSManager)manager).createName(opts.auth, null));
                    }
                    context = (ExtendedGSSContext)((GSSManager)manager).createContext(targetName, GSSConstants.MECH_OID, null, opts.lifetime);
                    context.requestCredDeleg(opts.deleg);
                    context.requestConf(opts.conf);
                    context.requestAnonymity(opts.anonymity);
                    context.setOption(GSSConstants.GSS_MODE, opts.gsiMode ? GSIConstants.MODE_GSI : GSIConstants.MODE_SSL);
                    if (opts.deleg) {
                        context.setOption(GSSConstants.DELEGATION_TYPE, opts.limitedDeleg ? GSIConstants.DELEGATION_TYPE_LIMITED : GSIConstants.DELEGATION_TYPE_FULL);
                    }
                    context.setOption(GSSConstants.REJECT_LIMITED_PROXY, new Boolean(opts.rejectLimitedProxy));
                    while (!context.isEstablished()) {
                        outToken = context.initSecContext(inToken, 0, inToken.length);
                        if (outToken != null) {
                            out.write(outToken);
                            out.flush();
                        }
                        if (context.isEstablished()) continue;
                        inToken = SSLUtil.readSslMessage(in);
                    }
                    System.out.println("Context established.");
                    System.out.println("Initiator : " + context.getSrcName());
                    System.out.println("Acceptor  : " + context.getTargName());
                    System.out.println("Lifetime  : " + context.getLifetime());
                    System.out.println("Privacy   : " + context.getConfState());
                    System.out.println("Anonymity : " + context.getAnonymityState());
                    String msg = "POST ping/jobmanager HTTP/1.1\r\nHost: " + host + "\r\n" + "Content-Type: application/x-globus-gram\r\n" + "Content-Length: 0\r\n\r\n";
                    byte[] tmp = msg.getBytes();
                    outToken = context.wrap(tmp, 0, tmp.length, null);
                    out.write(outToken);
                    out.flush();
                    inToken = SSLUtil.readSslMessage(in);
                    outToken = context.unwrap(inToken, 0, inToken.length, null);
                    System.out.println(new String(outToken));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (context == null) break block25;
                    try {
                        System.out.println("closing...");
                        context.dispose();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {}
                }
                if (context != null) {
                    try {
                        System.out.println("closing...");
                        context.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

