/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.example;

public class GetOpts {
    public boolean conf = true;
    public int lifetime = 0;
    public boolean gsiMode = true;
    public boolean deleg = false;
    public boolean limitedDeleg = true;
    public boolean rejectLimitedProxy = false;
    public boolean anonymity = false;
    public String auth = null;
    protected String usage;
    protected String helpMsg;

    public GetOpts(String usage, String helpMsg) {
        this.usage = usage;
        this.helpMsg = helpMsg;
    }

    public int parse(String[] args) {
        int i = 0;
        i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') break;
            i += this.parseArg(args, i);
            ++i;
        }
        return i;
    }

    protected int parseArg(String[] args, int i) {
        int j = 0;
        if (args[i].equalsIgnoreCase("-enable-conf")) {
            this.conf = true;
        } else if (args[i].equalsIgnoreCase("-disable-conf")) {
            this.conf = false;
        } else if (args[i].equalsIgnoreCase("-gss-mode")) {
            String arg;
            if ((arg = args[++i]).equalsIgnoreCase("ssl")) {
                this.gsiMode = false;
            } else if (arg.equalsIgnoreCase("gsi")) {
                this.gsiMode = true;
            } else {
                GetOpts.error("Invalid -gss-mode argument: " + arg);
            }
            j = 1;
        } else if (args[i].equalsIgnoreCase("-deleg-type")) {
            String arg;
            if ((arg = args[++i]).equalsIgnoreCase("full")) {
                this.limitedDeleg = false;
                this.deleg = true;
            } else if (arg.equalsIgnoreCase("limited")) {
                this.limitedDeleg = true;
                this.deleg = true;
            } else if (arg.equalsIgnoreCase("none")) {
                this.deleg = false;
            } else {
                GetOpts.error("Invalid -deleg-type argument: " + arg);
            }
            j = 1;
        } else if (args[i].equalsIgnoreCase("-auth")) {
            String arg;
            this.auth = (arg = args[++i]).equalsIgnoreCase("host") ? "host" : (arg.equalsIgnoreCase("self") ? "self" : arg);
            j = 1;
        } else if (args[i].equalsIgnoreCase("-lifetime")) {
            this.lifetime = Integer.parseInt(args[++i]);
            j = 1;
        } else if (args[i].equalsIgnoreCase("-rejectLimitedProxy")) {
            this.rejectLimitedProxy = true;
        } else if (args[i].equalsIgnoreCase("-anonymous")) {
            this.anonymity = true;
        } else if (args[i].equalsIgnoreCase("-help")) {
            System.err.println(this.usage);
            System.err.println();
            System.err.println(this.helpMsg);
            System.exit(0);
        } else {
            System.err.println("Argument not recognized: " + args[i]);
            System.exit(1);
        }
        return j;
    }

    protected static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

