/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class HostAuthorization
extends GSSAuthorization {
    private static Log logger = LogFactory.getLog(HostAuthorization.class.getName());
    public static final HostAuthorization ldapAuthorization = new HostAuthorization("ldap");
    private String _service = null;
    private static HostAuthorization hostAuthorization;

    public HostAuthorization(String service) {
        this._service = service == null ? "host" : service;
    }

    public static synchronized HostAuthorization getInstance() {
        if (hostAuthorization == null) {
            hostAuthorization = new HostAuthorization("host");
        }
        return hostAuthorization;
    }

    @Override
    public GSSName getExpectedName(GSSCredential cred, String host) throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        return manager.createName(String.valueOf(this._service) + "@" + host, GSSName.NT_HOSTBASED_SERVICE);
    }

    @Override
    public void authorize(GSSContext context, String host) throws AuthorizationException {
        logger.debug("Authorization: HOST");
        try {
            GSSName expected = this.getExpectedName(null, host);
            GSSName target = null;
            target = context.isInitiator() ? context.getTargName() : context.getSrcName();
            if (!expected.equals(target)) {
                this.generateAuthorizationException(expected, target);
            }
        }
        catch (GSSException e) {
            throw new AuthorizationException("Authorization failure", e);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof HostAuthorization) {
            HostAuthorization other = (HostAuthorization)o;
            if (this._service == null) {
                return other._service == null;
            }
            return this._service.equals(other._service);
        }
        return false;
    }

    public int hashCode() {
        return this._service == null ? 0 : this._service.hashCode();
    }
}

