/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSContextImpl;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.gsi.jaas.JaasSubject;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GlobusGSSManagerImpl
extends ExtendedGSSManager {
    private static Log logger = LogFactory.getLog(GlobusGSSManagerImpl.class.getName());
    static final Oid[] MECHS;
    private GlobusGSSCredentialImpl defaultCred;

    static {
        try {
            MECHS = new Oid[]{GSSConstants.MECH_OID};
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public GSSCredential createCredential(int usage) throws GSSException {
        return this.createCredential((GSSName)null, 0, (Oid)null, usage);
    }

    @Override
    public GSSCredential createCredential(GSSName name, int lifetime, Oid mech, int usage) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (name != null) {
            if (name.isAnonymous()) {
                return new GlobusGSSCredentialImpl();
            }
            throw new GSSException(16);
        }
        GlobusCredential cred = null;
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject != null) {
            Iterator<GlobusGSSCredentialImpl> iter;
            logger.debug("Getting credential from context");
            Set<GlobusGSSCredentialImpl> gssCreds = subject.getPrivateCredentials(GlobusGSSCredentialImpl.class);
            if (gssCreds != null && (iter = gssCreds.iterator()).hasNext()) {
                GlobusGSSCredentialImpl credImpl = iter.next();
                cred = credImpl.getGlobusCredential();
            }
        }
        if (lifetime == Integer.MAX_VALUE || lifetime > 0) {
            throw new GlobusGSSException(11, 7, "badLifetime01");
        }
        if (cred == null) {
            logger.debug("Getting default credential");
            try {
                cred = GlobusCredential.getDefaultCredential();
            }
            catch (GlobusCredentialException e) {
                if (e.getErrorCode() == 1) {
                    throw new GSSException(8);
                }
                throw new GlobusGSSException(9, (Throwable)e);
            }
            catch (Exception e) {
                throw new GlobusGSSException(9, (Throwable)e);
            }
            return this.getDefaultCredential(cred, usage);
        }
        return new GlobusGSSCredentialImpl(cred, usage);
    }

    private synchronized GSSCredential getDefaultCredential(GlobusCredential cred, int usage) throws GSSException {
        if (this.defaultCred != null && this.defaultCred.getUsage() == usage && this.defaultCred.getGlobusCredential() == cred) {
            return this.defaultCred;
        }
        this.defaultCred = new GlobusGSSCredentialImpl(cred, usage);
        return this.defaultCred;
    }

    @Override
    public GSSCredential createCredential(GSSName name, int lifetime, Oid[] mechs, int usage) throws GSSException {
        if (mechs == null || mechs.length == 0) {
            return this.createCredential(name, lifetime, (Oid)null, usage);
        }
        GSSCredential cred = this.createCredential(name, lifetime, mechs[0], usage);
        int i = 1;
        while (i < mechs.length) {
            cred.add(name, lifetime, lifetime, mechs[i], usage);
            ++i;
        }
        return cred;
    }

    @Override
    public GSSCredential createCredential(byte[] buff, int option, int lifetime, Oid mech, int usage) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (buff == null || buff.length < 1) {
            throw new GlobusGSSException(11, 7, "invalidBuf");
        }
        if (lifetime == Integer.MAX_VALUE || lifetime > 0) {
            throw new GlobusGSSException(11, 7, "badLifetime01");
        }
        InputStream input = null;
        switch (option) {
            case 0: {
                input = new ByteArrayInputStream(buff);
                break;
            }
            case 1: {
                String s = new String(buff);
                int pos = s.indexOf(61);
                if (pos == -1) {
                    throw new GSSException(11);
                }
                String filename = s.substring(pos + 1).trim();
                try {
                    input = new FileInputStream(filename);
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            default: {
                throw new GlobusGSSException(11, 7, "unknownOption", new Object[]{new Integer(option)});
            }
        }
        GlobusCredential cred = null;
        try {
            cred = new GlobusCredential(input);
        }
        catch (GlobusCredentialException e) {
            if (e.getErrorCode() == 1) {
                throw new GSSException(8);
            }
            throw new GlobusGSSException(9, (Throwable)e);
        }
        catch (Exception e) {
            throw new GlobusGSSException(9, (Throwable)e);
        }
        return new GlobusGSSCredentialImpl(cred, usage);
    }

    @Override
    public GSSContext createContext(GSSName peer, Oid mech, GSSCredential cred, int lifetime) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        GlobusGSSCredentialImpl globusCred = null;
        if (cred == null) {
            globusCred = (GlobusGSSCredentialImpl)this.createCredential(1);
        } else if (cred instanceof GlobusGSSCredentialImpl) {
            globusCred = (GlobusGSSCredentialImpl)cred;
        } else {
            throw new GSSException(13);
        }
        GlobusGSSContextImpl ctx = new GlobusGSSContextImpl(peer, globusCred);
        ctx.requestLifetime(lifetime);
        return ctx;
    }

    @Override
    public GSSContext createContext(GSSCredential cred) throws GSSException {
        GlobusGSSCredentialImpl globusCred = null;
        if (cred == null) {
            globusCred = (GlobusGSSCredentialImpl)this.createCredential(2);
        } else if (cred instanceof GlobusGSSCredentialImpl) {
            globusCred = (GlobusGSSCredentialImpl)cred;
        } else {
            throw new GSSException(13);
        }
        GlobusGSSContextImpl ctx = new GlobusGSSContextImpl(null, globusCred);
        return ctx;
    }

    @Override
    public Oid[] getMechs() {
        return MECHS;
    }

    @Override
    public GSSName createName(String nameStr, Oid nameType) throws GSSException {
        return new GlobusGSSName(nameStr, nameType);
    }

    public static void checkMechanism(Oid mech) throws GSSException {
        if (mech != null && !mech.equals(GSSConstants.MECH_OID)) {
            throw new GSSException(2);
        }
    }

    @Override
    public GSSContext createContext(byte[] interProcessToken) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public Oid[] getNamesForMech(Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public Oid[] getMechsForName(Oid nameType) {
        return null;
    }

    @Override
    public GSSName createName(String nameStr, Oid nameType, Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public GSSName createName(byte[] name, Oid nameType) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public GSSName createName(byte[] name, Oid nameType, Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public void addProviderAtFront(Provider p, Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    @Override
    public void addProviderAtEnd(Provider p, Oid mech) throws GSSException {
        throw new GSSException(16);
    }
}

