/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.globus.util.Base64;
import org.globus.util.I18n;
import org.globus.util.PEMUtils;
import org.globus.util.Util;

public abstract class OpenSSLKey {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", OpenSSLKey.class.getClassLoader());
    public static final String HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private String keyAlg = null;
    private boolean isEncrypted = false;
    private byte[] encodedKey = null;
    private PrivateKey intKey = null;
    private IvParameterSpec iv = null;
    private String encAlgStr = null;
    private String encAlg = null;
    private int keyLength = -1;
    private int ivLength = -1;
    private byte[] keyData = null;

    public OpenSSLKey(InputStream is) throws IOException, GeneralSecurityException {
        InputStreamReader isr = new InputStreamReader(is);
        this.readPEM(isr);
    }

    public OpenSSLKey(String file) throws IOException, GeneralSecurityException {
        FileReader f = null;
        try {
            f = new FileReader(file);
            this.readPEM(f);
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
    }

    public OpenSSLKey(PrivateKey key) {
        this.intKey = key;
        this.isEncrypted = false;
        this.keyData = this.getEncoded(key);
        this.encodedKey = null;
    }

    public OpenSSLKey(String algorithm, byte[] data) throws GeneralSecurityException {
        if (data == null) {
            throw new IllegalArgumentException(i18n.getMessage("dataNull"));
        }
        this.keyData = data;
        this.isEncrypted = false;
        this.intKey = this.getKey(algorithm, data);
    }

    protected byte[] getEncoded() {
        return this.keyData;
    }

    private void readPEM(Reader rd) throws IOException, GeneralSecurityException {
        BufferedReader in = new BufferedReader(rd);
        StringBuffer sb = new StringBuffer();
        String next = null;
        while ((next = in.readLine()) != null) {
            if (next.indexOf("PRIVATE KEY") == -1) continue;
            this.keyAlg = this.getKeyAlgorithm(next);
            break;
        }
        if (next == null) {
            throw new InvalidKeyException(i18n.getMessage("noPrivateKey"));
        }
        if (this.keyAlg == null) {
            throw new InvalidKeyException(i18n.getMessage("algNotSup"));
        }
        next = in.readLine();
        if (next.startsWith("Proc-Type: 4,ENCRYPTED")) {
            this.isEncrypted = true;
            this.parseEncryptionInfo(in.readLine());
            in.readLine();
        } else {
            this.isEncrypted = false;
            sb.append(next);
        }
        while ((next = in.readLine()) != null) {
            if (next.startsWith("-----END")) break;
            sb.append(next);
        }
        this.encodedKey = sb.toString().getBytes();
        if (!this.isEncrypted()) {
            this.keyData = Base64.decode(this.encodedKey);
            this.intKey = this.getKey(this.keyAlg, this.keyData);
        } else {
            this.keyData = null;
        }
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void decrypt(String password) throws GeneralSecurityException, InvalidKeyException {
        this.decrypt(password.getBytes());
    }

    public void decrypt(byte[] password) throws GeneralSecurityException, InvalidKeyException {
        if (!this.isEncrypted()) {
            return;
        }
        byte[] enc = Base64.decode(this.encodedKey);
        SecretKeySpec key = this.getSecretKey(password, this.iv.getIV());
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)key, this.iv);
        enc = cipher.doFinal(enc);
        this.intKey = this.getKey(this.keyAlg, enc);
        this.keyData = enc;
        this.isEncrypted = false;
        this.encodedKey = null;
    }

    public void encrypt(String password) throws GeneralSecurityException {
        this.encrypt(password.getBytes());
    }

    public void encrypt(byte[] password) throws GeneralSecurityException {
        if (this.isEncrypted()) {
            return;
        }
        if (this.encAlg == null) {
            this.setEncryptionAlgorithm("DES-EDE3-CBC");
        }
        if (this.iv == null) {
            this.iv = this.generateIV();
        }
        SecretKeySpec key = this.getSecretKey(password, this.iv.getIV());
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)key, this.iv);
        this.keyData = cipher.doFinal(this.getEncoded(this.intKey));
        this.isEncrypted = true;
        this.encodedKey = null;
    }

    public void setEncryptionAlgorithm(String alg) throws GeneralSecurityException {
        this.setAlgorithmSettings(alg);
    }

    public PrivateKey getPrivateKey() {
        return this.intKey;
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.toPEM().getBytes());
    }

    public void writeTo(Writer w) throws IOException {
        w.write(this.toPEM());
    }

    public void writeTo(String file) throws IOException {
        PrintWriter p = null;
        try {
            File f = Util.createFile(file);
            Util.setOwnerAccessOnly(file);
            p = new PrintWriter(new FileOutputStream(f));
            p.write(this.toPEM());
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
    }

    protected abstract byte[] getEncoded(PrivateKey var1);

    protected abstract PrivateKey getKey(String var1, byte[] var2) throws GeneralSecurityException;

    protected String getProvider() {
        return null;
    }

    private Cipher getCipher() throws GeneralSecurityException {
        String provider = this.getProvider();
        if (provider == null) {
            return Cipher.getInstance(String.valueOf(this.encAlg) + "/CBC/PKCS5Padding");
        }
        return Cipher.getInstance(String.valueOf(this.encAlg) + "/CBC/PKCS5Padding", provider);
    }

    private String getKeyAlgorithm(String line) {
        if (line.indexOf("RSA") != -1) {
            return "RSA";
        }
        if (line.indexOf("DSA") != -1) {
            return "DSA";
        }
        return null;
    }

    private void parseEncryptionInfo(String line) throws GeneralSecurityException {
        String keyInfo = line.substring(10);
        StringTokenizer tknz = new StringTokenizer(keyInfo, ",", false);
        this.setAlgorithmSettings(tknz.nextToken());
        this.setIV(tknz.nextToken());
    }

    private void setAlgorithmSettings(String alg) throws GeneralSecurityException {
        if (alg.equals("DES-EDE3-CBC")) {
            this.encAlg = "DESede";
            this.keyLength = 24;
            this.ivLength = 8;
        } else if (alg.equals("AES-128-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 16;
            this.ivLength = 16;
        } else if (alg.equals("AES-192-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 24;
            this.ivLength = 16;
        } else if (alg.equals("AES-256-CBC")) {
            this.encAlg = "AES";
            this.keyLength = 32;
            this.ivLength = 16;
        } else if (alg.equals("DES-CBC")) {
            this.encAlg = "DES";
            this.keyLength = 8;
            this.ivLength = 8;
        } else {
            throw new GeneralSecurityException(i18n.getMessage("unsupEnc", alg));
        }
        this.encAlgStr = alg;
    }

    private void setIV(String s) throws GeneralSecurityException {
        int len = s.length() / 2;
        if (len != this.ivLength) {
            String err = i18n.getMessage("ivLength", new String[]{Integer.toString(this.ivLength), Integer.toString(len)});
            throw new GeneralSecurityException(err);
        }
        byte[] ivBytes = new byte[len];
        int j = 0;
        while (j < len) {
            ivBytes[j] = (byte)Integer.parseInt(s.substring(j * 2, j * 2 + 2), 16);
            ++j;
        }
        this.iv = new IvParameterSpec(ivBytes);
    }

    private IvParameterSpec generateIV() {
        byte[] b = new byte[this.ivLength];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return new IvParameterSpec(b);
    }

    private SecretKeySpec getSecretKey(byte[] pwd, byte[] iv) throws GeneralSecurityException {
        byte[] key = new byte[this.keyLength];
        int offset = 0;
        int bytesNeeded = this.keyLength;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        while (true) {
            md5.update(pwd);
            md5.update(iv, 0, 8);
            byte[] b = md5.digest();
            int len = bytesNeeded > b.length ? b.length : bytesNeeded;
            System.arraycopy(b, 0, key, offset, len);
            bytesNeeded = key.length - (offset += len);
            if (bytesNeeded == 0) break;
            md5.reset();
            md5.update(b);
        }
        return new SecretKeySpec(key, this.encAlg);
    }

    private String toPEM() {
        byte[] data = this.keyData == null ? this.encodedKey : Base64.encode(this.keyData);
        String header = HEADER;
        if (this.isEncrypted()) {
            StringBuffer buf = new StringBuffer(header);
            buf.append(PEMUtils.lineSep);
            buf.append("Proc-Type: 4,ENCRYPTED");
            buf.append(PEMUtils.lineSep);
            buf.append("DEK-Info: ").append(this.encAlgStr);
            buf.append(",").append(PEMUtils.toHex(this.iv.getIV()));
            buf.append(PEMUtils.lineSep);
            header = buf.toString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PEMUtils.writeBase64(out, header, data, "-----END RSA PRIVATE KEY-----");
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(i18n.getMessage("unexpErr")) + e.getMessage());
        }
        return new String(out.toByteArray());
    }
}

