/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.globus.common.ChainedException;
import org.globus.gram.internal.GRAMProtocolErrorConstants;

public class GramException
extends ChainedException
implements GRAMProtocolErrorConstants {
    private static ResourceBundle resources;
    public static final int SUCCESS = 0;
    public static final int INIT_CALLBACK_HANDLER_FAILED = 1000;
    public static final int ERROR_JOB_CONTACT_NOT_SET = 1003;
    public static final int CUSTOM_ERROR = 9999;
    protected int errorCode;

    static {
        try {
            resources = ResourceBundle.getBundle("org.globus.gram.internal.errors", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("org.globus.gram.internal.gramerrors.properties not found");
        }
    }

    public GramException() {
        super(GramException.getMessage(0));
        this.errorCode = 0;
    }

    public GramException(int ec) {
        super(GramException.getMessage(ec));
        this.errorCode = ec;
    }

    public GramException(String msg) {
        super(msg);
        this.errorCode = 9999;
    }

    public GramException(int ec, Throwable ex) {
        super(GramException.getMessage(ec), ex);
        this.errorCode = ec;
    }

    public void setErrorCode(int ec) {
        this.errorCode = ec;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public static String getMessage(int errorCode) {
        if (errorCode == 0) {
            return "Success";
        }
        if (resources == null) {
            return "Error code: " + errorCode;
        }
        try {
            return resources.getString(String.valueOf(errorCode));
        }
        catch (MissingResourceException mre) {
            return "Error code: " + errorCode;
        }
    }
}

