/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import org.globus.ftp.HostPort;

public class HostPort6
extends HostPort {
    public static final String IPv4 = "1";
    public static final String IPv6 = "2";
    private String host;
    private int port;
    private String version;

    public HostPort6(String version, String host, int port) {
        this.version = version;
        this.host = host;
        this.port = port;
    }

    public HostPort6(String passiveReplyMessage) {
        Parser tokens = new Parser(passiveReplyMessage);
        String token = null;
        token = tokens.nextToken().trim();
        if (token.length() != 0) {
            if (token.equals(IPv4)) {
                this.version = IPv4;
            } else if (token.equals(IPv6)) {
                this.version = IPv6;
            } else {
                throw new IllegalArgumentException("Invalid network protocol: " + token);
            }
        }
        if ((token = tokens.nextToken().trim()).length() != 0) {
            this.host = token;
        }
        if ((token = tokens.nextToken().trim()).length() == 0) {
            throw new IllegalArgumentException("Port number is required");
        }
        this.port = Integer.parseInt(token);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toFtpCmdArgument() {
        StringBuffer msg = new StringBuffer();
        msg.append("|");
        if (this.version != null) {
            msg.append(this.version);
        }
        msg.append("|");
        if (this.host != null) {
            msg.append(this.host);
        }
        msg.append("|");
        msg.append(String.valueOf(this.port));
        msg.append("|");
        return msg.toString();
    }

    public static String getIPAddressVersion(String address) {
        return address.indexOf(58) == -1 ? IPv4 : IPv6;
    }

    private static class Parser {
        String line;
        int offset = 0;

        public Parser(String line) {
            this.line = line;
        }

        public String nextToken() {
            int start = this.line.indexOf(124, this.offset);
            if (start == -1) {
                throw new IllegalArgumentException("Formatting error");
            }
            int end = this.line.indexOf(124, start + 1);
            if (end == -1) {
                throw new IllegalArgumentException("Formatting error");
            }
            this.offset = end;
            return this.line.substring(start + 1, end);
        }
    }
}

