/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MVHashtable
implements Serializable {
    protected Hashtable attribs;

    public MVHashtable() {
        this.attribs = new Hashtable();
    }

    public MVHashtable(int initialSize) {
        this.attribs = new Hashtable(initialSize);
    }

    public MVHashtable(MVHashtable multivaluedHashtable) {
        this.attribs = new Hashtable();
        Enumeration e = multivaluedHashtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Vector values = (Vector)multivaluedHashtable.attribs.get(key);
            this.add(key, values);
        }
    }

    public Vector set(String key, Object value) {
        Vector values = (Vector)this.attribs.get(key);
        Vector<Object> newValues = new Vector<Object>(1);
        newValues.addElement(value);
        this.attribs.put(key, newValues);
        return values;
    }

    public void add(String key, Object value) {
        Vector<Object> values = (Vector<Object>)this.attribs.get(key);
        if (values == null) {
            values = new Vector<Object>(1);
            this.attribs.put(key, values);
        }
        values.addElement(value);
    }

    public void add(String key, Object[] values) {
        Vector<Object> ivalues = (Vector<Object>)this.attribs.get(key);
        if (ivalues == null) {
            ivalues = new Vector<Object>(values.length);
            this.attribs.put(key, ivalues);
        }
        int size = values.length;
        int i = 0;
        while (i < size) {
            ivalues.add(values[i]);
            ++i;
        }
    }

    public void add(String key, Vector values) {
        Vector ivalues = (Vector)this.attribs.get(key);
        if (ivalues == null) {
            ivalues = new Vector(values.size());
            this.attribs.put(key, ivalues);
        }
        int size = values.size();
        int i = 0;
        while (i < size) {
            ivalues.add(values.elementAt(i));
            ++i;
        }
    }

    public void add(MVHashtable multivaluedHashtable) {
        Enumeration e = multivaluedHashtable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Vector values = multivaluedHashtable.get(key);
            this.add(key, values);
        }
    }

    public Object remove(String key) {
        return this.attribs.remove(key);
    }

    public boolean remove(String key, Object value) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return false;
        }
        return values.remove(value);
    }

    public Object remove(String key, int index) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return null;
        }
        return values.remove(index);
    }

    public void clear() {
        this.attribs.clear();
    }

    public int size() {
        return this.attribs.size();
    }

    public int size(String key) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return 0;
        }
        return values.size();
    }

    public boolean containsName(String key) {
        return this.attribs.containsKey(key);
    }

    public boolean contains(String key, Object value) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    public Enumeration keys() {
        return this.attribs.keys();
    }

    public Vector getKeys() {
        Vector<String> values = new Vector<String>(this.attribs.size());
        Enumeration theseVals = this.attribs.keys();
        while (theseVals.hasMoreElements()) {
            values.add((String)theseVals.nextElement());
        }
        return values;
    }

    public Vector get(String key) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return null;
        }
        return (Vector)values.clone();
    }

    public Object getFirstValue(String key) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return null;
        }
        return values.firstElement();
    }

    public Object getLastValue(String key) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return null;
        }
        return values.lastElement();
    }

    public Object getValueAt(String key, int index) {
        Vector values = (Vector)this.attribs.get(key);
        if (values == null) {
            return null;
        }
        if (values.size() > index) {
            return values.elementAt(index);
        }
        return null;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            Vector values = this.get(attribute);
            buf.append(attribute);
            buf.append("=");
            buf.append(values);
            if (!e.hasMoreElements()) continue;
            buf.append(" ; ");
        }
        return buf.toString();
    }
}

