/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.gridftp;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GridFtpProperties
extends Properties {
    private static final String GRIDFTP_KEYSTORE = "hila2.gridftp.keystore";
    private static final String GRIDFTP_KEYSTORE_PASS = "hila2.gridftp.keystore.password";
    private static final String GRIDFTP_KEYSTORE_ALIAS = "hila2.gridftp.keystore.alias";
    private KeyStore keystore = null;
    private static GridFtpProperties theInstance;

    public static synchronized GridFtpProperties getInstance() throws HiLAFactoryException {
        if (theInstance == null) {
            theInstance = new GridFtpProperties();
        }
        return theInstance;
    }

    public GridFtpProperties() throws HiLAFactoryException {
        try {
            this.load(new FileInputStream(new File(new File(System.getProperty("user.home"), ".hila2"), "gridftp.properties")));
        }
        catch (FileNotFoundException e) {
            throw new HiLAFactoryException("No GridFTP configuration file found.", e);
        }
        catch (IOException e) {
            throw new HiLAFactoryException("Unable to read GridFTP configuration file.", e);
        }
    }

    public synchronized KeyStore getKeystore() throws HiLAException {
        if (this.keystore == null) {
            try {
                this.keystore = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException e1) {
                throw new HiLAException("Unable to create keystore instance.", e1);
            }
            String ksLocation = this.getProperty(GRIDFTP_KEYSTORE);
            String ksPass = this.getProperty(GRIDFTP_KEYSTORE_PASS);
            if (ksLocation == null) {
                throw new HiLAException("Unable to load keystore, as hila2.gridftp.keystore has not been set.");
            }
            try {
                this.keystore.load(new FileInputStream(ksLocation), ksPass.toCharArray());
            }
            catch (Exception e) {
                throw new HiLAException("Unable to load keystore", e);
            }
        }
        return this.keystore;
    }

    public String getPassword() {
        return this.getProperty(GRIDFTP_KEYSTORE_PASS);
    }

    public String getAlias() {
        return this.getProperty(GRIDFTP_KEYSTORE_ALIAS);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.insertProviderAt(new BouncyCastleProvider(), 1);
        }
        theInstance = null;
    }
}

