/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.gridftp;

import eu.unicore.hila.HiLA;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.grid.BaseSimpleTransfer;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.gridftp.GridFTPStorage;
import eu.unicore.hila.gridftp.NonClosingBufferedOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.globus.ftp.DataSinkStream;
import org.globus.ftp.GridFTPClient;

public class GridFtpExport
extends BaseSimpleTransfer
implements SimpleTransfer,
Callable<TaskStatus> {
    private GridFTPStorage storage;
    private String path;
    private OutputStream os;
    private boolean closeOutputStream;

    public GridFtpExport(GridFTPStorage _storage, String _path, OutputStream _os, boolean _closeOutputStream) throws HiLALocationSyntaxException {
        super(_storage.getLocation().getChildLocation("exports").getChildLocation(UUID.randomUUID().toString()));
        this.storage = _storage;
        this.path = _path;
        this.os = _os;
        this.closeOutputStream = _closeOutputStream;
        HiLA.getExecutor().submit(this);
    }

    @Override
    public void abort() throws HiLAException {
        throw new HiLANotImplementedException("abort() not implemented for GridFTP transfers.");
    }

    @Override
    public String getId() throws HiLAException {
        return this.getLocation().getName();
    }

    @Override
    public List<Resource> getChildren() throws HiLAException {
        return Collections.emptyList();
    }

    @Override
    public TaskStatus call() throws Exception {
        this.setCurrentState(TaskStatus.RUNNING);
        try {
            GridFTPClient client = this.storage.lockClient();
            client.setPassive();
            client.setLocalActive();
            DataSinkStream ds = new DataSinkStream(new NonClosingBufferedOutputStream(this.os));
            client.get(this.path, ds, null);
            this.os.flush();
            if (this.closeOutputStream) {
                this.os.close();
            }
            this.setCurrentState(TaskStatus.SUCCESSFUL);
        }
        catch (Exception e) {
            HiLAException he = new HiLAException("File export failed.", e);
            this.setCurrentState(TaskStatus.FAILED, he);
            throw he;
        }
        finally {
            this.storage.unlockClient();
        }
        return this.status();
    }
}

