/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509DSAPublicKey;
import COM.claymoresystems.cert.X509RSAPublicKey;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Hashtable;

public class X509SubjectPublicKeyInfo {
    static Hashtable algorithmMap = new Hashtable();

    public static PublicKey createPublicKey(byte[] spkiDER) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            SSLDebug.debug(32, "SPKI encoding", spkiDER);
            CoderOperations der_coder = BaseCoder.getInstance("DER");
            ByteArrayInputStream is = new ByteArrayInputStream(spkiDER);
            der_coder.init(is);
            ASNObject spki = CertContext.getSpec().getComponent("SubjectPublicKeyInfo");
            spki.accept(der_coder, null);
            ASNObject tmp = spki.getComponent("SubjectPublicKeyInfo.algorithm");
            ASNObject params = tmp.getComponent("AlgorithmIdentifier.parameters");
            tmp = tmp.getComponent("AlgorithmIdentifier.algorithm");
            String algorithm = (String)tmp.getValue();
            byte[] param = (byte[])params.getValue();
            tmp = spki.getComponent("SubjectPublicKeyInfo.subjectPublicKey");
            byte[] pk = (byte[])tmp.getValue();
            if (algorithm.equals("1.2.840.113549.1.1.1")) {
                X509RSAPublicKey x509RSAPublicKey = new X509RSAPublicKey(algorithm, param, pk);
                return x509RSAPublicKey;
            }
            if (algorithm.equals("1.2.840.10040.4.1")) {
                X509DSAPublicKey x509DSAPublicKey = new X509DSAPublicKey(algorithm, param, pk);
                return x509DSAPublicKey;
            }
            throw new IOException("Unrecognized OID for key" + algorithm);
        }
    }

    public static byte[] encodePublicKey(byte[] OID, byte[] params, byte[] key) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DERUtils.encodeOID(OID, (OutputStream)os);
        os.write(params);
        byte[] algId_c = os.toByteArray();
        os.reset();
        DERUtils.encodeSequence(algId_c, (OutputStream)os);
        DERUtils.encodeBitString(key, os);
        byte[] tmp = os.toByteArray();
        os.reset();
        DERUtils.encodeSequence(tmp, (OutputStream)os);
        return os.toByteArray();
    }
}

