/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.globus.common.Version;

public class GridInfoSearch {
    private static final String version = Version.getVersion();
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private String hostname;
    private int port = 2135;
    private String baseDN = "mds-vo-name=local, o=grid";
    private int timeOutInSeconds = 30;
    private int scope = 2;
    private int ldapVersion = 3;
    private int sizeLimit = 0;
    private int timeLimit = 0;
    private boolean ldapTrace = false;
    private String saslMech = "GSI";
    private String bindDN;
    private String password;
    private String qop = "auth";
    private boolean verbose = false;

    private String getHostname() {
        if (this.hostname == null) {
            try {
                this.setHostname(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                System.err.println("Error getting hostname: " + e.getMessage());
                System.exit(1);
            }
        }
        return this.hostname;
    }

    private void search(String filter, String[] attributes) {
        block20: {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            String url = "ldap://" + this.getHostname() + ":" + this.port;
            if (this.verbose) {
                System.out.println("Connecting to: " + url);
            }
            env.put("java.naming.ldap.version", String.valueOf(this.ldapVersion));
            env.put("java.naming.factory.initial", DEFAULT_CTX);
            env.put("java.naming.provider.url", url);
            if (this.ldapTrace) {
                env.put("com.sun.jndi.ldap.trace.ber", System.err);
            }
            if (this.bindDN != null) {
                env.put("java.naming.security.principal", this.bindDN);
            }
            if (this.saslMech != null) {
                if (this.saslMech.equalsIgnoreCase("GSI") || this.saslMech.equalsIgnoreCase("GSS-OWNYQ6NTEOAUVGWG")) {
                    this.saslMech = "GSS-OWNYQ6NTEOAUVGWG";
                    env.put("javax.security.sasl.client.pkgs", "org.globus.mds.gsi.jndi");
                }
                env.put("java.naming.security.authentication", this.saslMech);
                env.put("javax.security.sasl.qop", this.qop);
            } else {
                env.put("java.naming.security.authentication", "simple");
                if (this.password != null) {
                    env.put("java.naming.security.credentials", this.password);
                }
            }
            InitialLdapContext ctx = null;
            try {
                try {
                    ctx = new InitialLdapContext(env, null);
                    SearchControls constraints = new SearchControls();
                    constraints.setSearchScope(this.scope);
                    constraints.setCountLimit(this.sizeLimit);
                    constraints.setTimeLimit(this.timeLimit);
                    constraints.setReturningAttributes(attributes);
                    NamingEnumeration<SearchResult> results = ctx.search(this.baseDN, filter, constraints);
                    this.displayResults(results);
                }
                catch (Exception e) {
                    System.err.println("Failed to search: " + e.getMessage());
                    if (this.verbose) {
                        e.printStackTrace();
                    }
                    if (ctx == null) break block20;
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void displayResults(NamingEnumeration results) throws NamingException {
        if (results != null) ** GOTO lbl17
        return;
lbl-1000:
        // 1 sources

        {
            si = (SearchResult)results.next();
            attrs = si.getAttributes();
            dn = si.getName().trim().length() == 0 ? this.baseDN : String.valueOf(si.getName()) + ", " + this.baseDN;
            System.out.println("dn: " + dn);
            ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                at = ae.next();
                attribute = at.getID();
                vals = at.getAll();
                while (vals.hasMoreElements()) {
                    System.out.println(String.valueOf(attribute) + ": " + vals.nextElement());
                }
            }
            System.out.println();
lbl17:
            // 2 sources

            ** while (results.hasMoreElements())
        }
lbl18:
        // 1 sources

    }

    public static String getVersion() {
        return version;
    }

    private void setScope(int scope) {
        this.scope = scope;
    }

    private void setLdapVersion(int version) {
        this.ldapVersion = version;
    }

    private void setSizeLimit(int limit) {
        this.sizeLimit = limit;
    }

    private void setTimeLimit(int limit) {
        this.timeLimit = limit;
    }

    private void setLdapTrace(boolean trace) {
        this.ldapTrace = trace;
    }

    private void setHostname(String hostname) {
        this.hostname = hostname;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    private void setTimeout(int timeOutInSeconds) {
        this.timeOutInSeconds = timeOutInSeconds;
    }

    private void setSaslMech(String mech) {
        this.saslMech = mech;
    }

    private void setQOP(String qop) {
        this.qop = qop;
    }

    private void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    private void setPassword(String pwd) {
        this.password = pwd;
    }

    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private boolean isVerbose() {
        return this.verbose;
    }

    private String getSyntaxString() {
        return "\nSyntax : grid-info-search [ options ] <search filter> [attributes]\n\nUse -help to display full usage.";
    }

    private String getHelpString() {
        return "\ngrid-info-search [ options ] <search filter> [attributes]\n\n    Searches the MDS server based on the search filter, where some\n    options are:\n       -help\n               Displays this message\n\n       -version\n               Displays the current version number\n\n       -mdshost host (-h)\n               The host name on which the MDS server is running\n               The default is " + this.getHostname() + ".\n" + "\n" + "       -mdsport port (-p)\n" + "               The port number on which the MDS server is running\n" + "               The default is " + String.valueOf(this.port) + "\n" + "\n" + "       -mdsbasedn branch-point (-b)\n" + "               Location in DIT from which to start the search\n" + "               The default is '" + this.baseDN + "'\n" + "\n" + "       -mdstimeout seconds (-T)\n" + "               The amount of time (in seconds) one should allow to\n" + "               wait on an MDS request. The default is " + String.valueOf(this.timeOutInSeconds) + "\n" + "\n" + "       -anonymous (-x)\n" + "               Use anonymous binding instead of GSSAPI." + "\n\n" + "     grid-info-search also supports some of the flags that are\n" + "     defined in the LDAP v3 standard.\n" + "     Supported flags:\n\n" + "      -s scope   one of base, one, or sub (search scope)\n" + "      -P version protocol version (default: 3)\n" + "      -l limit   time limit (in seconds) for search\n" + "      -z limit   size limit (in entries) for search\n" + "      -Y mech    SASL mechanism\n" + "      -D binddn  bind DN\n" + "      -v         run in verbose mode (diagnostics to standard output)\n" + "      -O props   SASL security properties (auth, auth-conf, auth-int)\n" + "      -w passwd  bind password (for simple authentication)\n" + "\n";
    }

    private static String getValue(int i, String[] args, String option) {
        if (i >= args.length) {
            System.err.println("Error: argument required for : " + option);
            System.exit(1);
        }
        return args[i];
    }

    private static int getValueAsInt(int i, String[] args, String option) {
        String value = GridInfoSearch.getValue(i, args, option);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            System.err.println("Error: value '" + value + "' is not an integer for : " + option);
            System.exit(1);
            return -1;
        }
    }

    public static void main(String[] args) {
        GridInfoSearch gridInfoSearch = new GridInfoSearch();
        int i = 0;
        while (i < args.length) {
            if (!args[i].startsWith("-")) break;
            String option = args[i];
            if (option.equalsIgnoreCase("-ldapTrace")) {
                gridInfoSearch.setLdapTrace(true);
            } else if (option.equalsIgnoreCase("-help")) {
                System.err.println(gridInfoSearch.getHelpString());
                System.exit(0);
            } else if (option.equalsIgnoreCase("-version")) {
                System.err.println(GridInfoSearch.getVersion());
                System.exit(0);
            } else if (option.equalsIgnoreCase("-mdshost") || option.equals("-h")) {
                gridInfoSearch.setHostname(GridInfoSearch.getValue(++i, args, option));
            } else if (option.equalsIgnoreCase("-mdsport") || option.equals("-p")) {
                gridInfoSearch.setPort(GridInfoSearch.getValueAsInt(++i, args, option));
            } else if (option.equalsIgnoreCase("-mdsbasedn") || option.equals("-b")) {
                gridInfoSearch.setBaseDN(GridInfoSearch.getValue(++i, args, option));
            } else if (option.equalsIgnoreCase("-mdstimeout") || option.equals("-T")) {
                gridInfoSearch.setTimeout(GridInfoSearch.getValueAsInt(++i, args, option));
            } else if (option.equals("-s")) {
                String value;
                if ((value = GridInfoSearch.getValue(++i, args, option)).equalsIgnoreCase("one")) {
                    gridInfoSearch.setScope(1);
                } else if (value.equalsIgnoreCase("base")) {
                    gridInfoSearch.setScope(0);
                } else if (value.equalsIgnoreCase("sub")) {
                    gridInfoSearch.setScope(2);
                } else {
                    System.err.println("Error: invalid scope parameter : " + value);
                    System.exit(1);
                }
            } else if (option.equals("-P")) {
                gridInfoSearch.setLdapVersion(GridInfoSearch.getValueAsInt(++i, args, option));
            } else if (option.equals("-l")) {
                gridInfoSearch.setTimeLimit(GridInfoSearch.getValueAsInt(++i, args, option));
            } else if (option.equals("-z")) {
                gridInfoSearch.setSizeLimit(GridInfoSearch.getValueAsInt(++i, args, option));
            } else if (option.equals("-Y")) {
                gridInfoSearch.setSaslMech(GridInfoSearch.getValue(++i, args, option));
            } else if (option.equals("-D")) {
                gridInfoSearch.setBindDN(GridInfoSearch.getValue(++i, args, option));
            } else if (option.equals("-v")) {
                gridInfoSearch.setVerbose(true);
            } else if (option.equals("-x") || option.equalsIgnoreCase("-anonymous")) {
                gridInfoSearch.setSaslMech(null);
            } else if (option.equals("-O")) {
                gridInfoSearch.setQOP(GridInfoSearch.getValue(++i, args, option));
            } else if (option.equals("-w")) {
                gridInfoSearch.setPassword(GridInfoSearch.getValue(++i, args, option));
            } else {
                System.err.println("Error: unrecognized argument : " + option);
                System.exit(1);
            }
            ++i;
        }
        String filter = null;
        filter = i == args.length ? "(objectclass=*)" : args[i];
        String[] attribs = null;
        if (++i < args.length) {
            int size = args.length - i;
            attribs = new String[size];
            System.arraycopy(args, i, attribs, 0, size);
        }
        if (gridInfoSearch.isVerbose()) {
            System.out.println("filter: " + filter);
            if (attribs == null) {
                System.out.println("attribs: none");
            } else {
                System.out.print("attribs: ");
                i = 0;
                while (i < attribs.length) {
                    System.out.print(String.valueOf(attribs[i]) + " ");
                    ++i;
                }
                System.out.println();
            }
        }
        gridInfoSearch.search(filter, attribs);
    }
}

