/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Map;
import org.globus.rsl.RslEvaluationException;

public class Value {
    protected String value;
    protected Value concatValue;

    public Value(String value) {
        this(value, null);
    }

    public Value(String value, Value concatValue) {
        this.value = value;
        this.concatValue = concatValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value src = (Value)obj;
            if (src.getValue() == null ? this.getValue() != null : !src.getValue().equals(this.getValue())) {
                return false;
            }
            return !(src.getConcat() == null ? this.getConcat() != null : !src.getConcat().equals(this.getConcat()));
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.value != null) {
            hashCode += this.value.hashCode();
        }
        if (this.concatValue != null) {
            hashCode += this.concatValue.hashCode();
        }
        return hashCode;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Value getConcat() {
        return this.concatValue;
    }

    public void concat(Value value) {
        if (this.concatValue != null) {
            this.concatValue.concat(value);
        } else {
            this.concatValue = value;
        }
    }

    public String evaluate(Map symbolTable) throws RslEvaluationException {
        if (this.concatValue == null) {
            return this.value;
        }
        StringBuffer buf = new StringBuffer(this.value);
        buf.append(this.concatValue.evaluate(symbolTable));
        return buf.toString();
    }

    public String toRSL(boolean explicitConcat) {
        StringBuffer buf = new StringBuffer();
        this.toRSL(buf, explicitConcat);
        return buf.toString();
    }

    private String quotify(String str) {
        char quoteChar = '\"';
        int size = str.length();
        StringBuffer buf = new StringBuffer(size + 2);
        buf.append(quoteChar);
        int i = 0;
        while (i < size) {
            char curChar = str.charAt(i);
            if (curChar == quoteChar) {
                buf.append(curChar);
            }
            buf.append(curChar);
            ++i;
        }
        buf.append(quoteChar);
        return buf.toString();
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        if (explicitConcat) {
            buf.append(this.quotify(this.value));
        } else {
            buf.append(this.value);
        }
        if (this.concatValue == null) {
            return;
        }
        if (explicitConcat) {
            buf.append(" # ");
        }
        this.concatValue.toRSL(buf, explicitConcat);
    }

    public String getCompleteValue() {
        if (this.concatValue == null) {
            return this.value;
        }
        StringBuffer buf = new StringBuffer(this.value);
        buf.append(this.concatValue.getCompleteValue());
        return buf.toString();
    }

    public String toString() {
        return this.getCompleteValue();
    }
}

