/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import org.globus.net.PortRange;
import org.globus.net.WrappedSocket;

public class SocketFactory {
    private static SocketFactory defaultFactory = null;
    private PortRange portRange = PortRange.getTcpSourceInstance();

    protected SocketFactory() {
    }

    public static synchronized SocketFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new SocketFactory();
        }
        return defaultFactory;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket(InetAddress.getByName(host), port, null, 0);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.createSocket(address, port, null, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.createSocket(InetAddress.getByName(host), port, localAddr, localPort);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.portRange.isEnabled() && localPort == 0) {
            return new PrSocket(this.createSocket(address, port, localAddr));
        }
        return new Socket(address, port, localAddr, localPort);
    }

    private Socket createSocket(InetAddress address, int port, InetAddress localAddr) throws IOException {
        Socket socket = null;
        int localPort = 0;
        while (true) {
            localPort = this.portRange.getFreePort(localPort);
            try {
                socket = new Socket(address, port, localAddr, localPort);
                this.portRange.setUsed(localPort);
                return socket;
            }
            catch (BindException e) {
                ++localPort;
                continue;
            }
            break;
        }
    }

    class PrSocket
    extends WrappedSocket {
        public PrSocket(Socket socket) {
            super(socket);
        }

        @Override
        public void close() throws IOException {
            int port = this.getLocalPort();
            try {
                super.close();
            }
            finally {
                if (port != -1) {
                    SocketFactory.this.portRange.free(port);
                }
            }
        }
    }
}

