/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import org.globus.common.ChainedIOException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.GSIURLConnection;
import org.globus.util.http.HTTPChunkedInputStream;
import org.globus.util.http.HTTPChunkedOutputStream;
import org.globus.util.http.HTTPProtocol;
import org.globus.util.http.HTTPResponseParser;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GSIHttpURLConnection
extends GSIURLConnection {
    public static final int PORT = 8443;
    private static final String USER_AGENT = "Java-Globus-GASS-HTTP/1.1.0";
    private static final String POST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private Socket socket;
    private int port;
    private HTTPResponseParser response;
    private InputStream is;
    private OutputStream os;

    public GSIHttpURLConnection(URL u) {
        super(u);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.port = this.url.getPort() == -1 ? 8443 : this.url.getPort();
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = null;
        try {
            context = (ExtendedGSSContext)manager.createContext(this.getExpectedName(), GSSConstants.MECH_OID, this.credentials, 0);
            switch (this.delegationType) {
                case 1: {
                    context.requestCredDeleg(false);
                    break;
                }
                case 2: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_LIMITED);
                    break;
                }
                case 3: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_FULL);
                    break;
                }
                default: {
                    context.requestCredDeleg(true);
                    context.setOption(GSSConstants.DELEGATION_TYPE, new Integer(this.delegationType));
                }
            }
            if (this.gssMode != null) {
                context.setOption(GSSConstants.GSS_MODE, this.gssMode);
            }
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to init GSI context", e);
        }
        GssSocketFactory factory = GssSocketFactory.getDefault();
        this.socket = factory.createSocket(this.url.getHost(), this.port, context);
        ((GssSocket)this.socket).setAuthorization(this.authorization);
    }

    @Override
    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.is != null && this.os == null) {
            throw new ProtocolException("Cannot write output after reading input");
        }
        if (this.os == null) {
            this.connect();
            String header = HTTPProtocol.createPUTHeader(this.url.getFile(), String.valueOf(this.url.getHost()) + ":" + this.port, USER_AGENT, POST_CONTENT_TYPE, -1L, true);
            OutputStream wrapped = this.socket.getOutputStream();
            wrapped.write(header.getBytes());
            this.os = new HTTPChunkedOutputStream(wrapped);
        }
        return this.os;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
            if (this.os == null) {
                OutputStream out = this.socket.getOutputStream();
                String msg = HTTPProtocol.createGETHeader(this.url.getFile(), String.valueOf(this.url.getHost()) + ":" + this.port, USER_AGENT);
                out.write(msg.getBytes());
                out.flush();
            } else {
                this.os.flush();
                this.os.close();
                this.os = null;
            }
            InputStream in = this.socket.getInputStream();
            this.response = new HTTPResponseParser(in);
            if (!this.response.isOK()) {
                throw new IOException(this.response.getMessage());
            }
            this.is = this.response.isChunked() ? new HTTPChunkedInputStream(in) : in;
        }
        return this.is;
    }

    @Override
    public String getHeaderField(String name) {
        if (this.response == null) {
            return null;
        }
        if (name.equalsIgnoreCase("content-type")) {
            return this.response.getContentType();
        }
        if (name.equalsIgnoreCase("content-length")) {
            return String.valueOf(this.response.getContentLength());
        }
        return null;
    }
}

